/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.OrderBy;
import org.dromara.mendmix.common.model.Page;
import org.dromara.mendmix.common.util.CachingFieldUtils;
import org.dromara.mendmix.common.util.JsonUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.StringConverter;
import org.dromara.mendmix.mybatis.DeptPermType;
import org.dromara.mendmix.mybatis.MybatisConfigs;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.crud.CrudMethods;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.kit.MybatisSqlRewriteUtils;
import org.dromara.mendmix.mybatis.metadata.ColumnMetadata;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.rewrite.ConditionPair;
import org.dromara.mendmix.mybatis.plugin.rewrite.DataPermissionStrategy;
import org.dromara.mendmix.mybatis.plugin.rewrite.RewriteSqlOnceContext;
import org.dromara.mendmix.mybatis.plugin.rewrite.RewriteTable;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.ConditionWithSubSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRewriteHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    private static Pattern multiSqlSpiterPattern = Pattern.compile(";\\s{0,}(UPDATE|INSERT)\\s+", 2);
    private static final String ARRAY_START = "[";
    private static final String QUERY_FUZZY_CHAR = "%";
    private static final String SQL_CACHE_KEY = "__SQL_CACHE__";
    public static final String FRCH_PREFIX = "__frch_";
    private static final String FRCH_INDEX_PREFIX = "__frch_index_";
    private static final String FRCH_ITEM_PREFIX = "__frch_item_";
    private static EqualsTo noPermssionCondition = new EqualsTo();
    private static EqualsTo ignorePermssionCondition = new EqualsTo();
    private Map<String, LinkedHashMap<String, List<String>>> tableDataPermColumnMappings = new HashMap<String, LinkedHashMap<String, List<String>>>();
    private List<String[]> globalOrRelationColumns = new ArrayList<String[]>();
    private Map<String, List<String[]>> tableOrRelationColumns = new HashMap<String, List<String[]>>();
    private List<String> softDeleteMappedStatements = new ArrayList<String>();
    private List<String> deptMappedStatements = new ArrayList<String>();
    private boolean dynaDataPermEnaled;
    private String softDeleteColumn;
    private String softDeletePropName;
    private String softDeleteFalseValue;
    private boolean softDeleteFalseValueAsNumber;
    private boolean isFieldSharddingTenant;
    private String tenantColumnName;
    private String tenantPropName;
    private String bUnitColumnName;
    private String bUnitPropName;
    private String deptColumnName;
    private String deptPropName;
    private String createdByColumnName;
    private List<PluginInterceptorHandler> compatibleHandlers;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.compatibleHandlers = context.getInterceptorHandlers().stream().filter(o -> o.compatibleSqlRewrite()).collect(Collectors.toList());
        noPermssionCondition = new EqualsTo();
        noPermssionCondition.setLeftExpression((Expression)new Column("1"));
        noPermssionCondition.setRightExpression((Expression)new LongValue(2L));
        ignorePermssionCondition = new EqualsTo();
        ignorePermssionCondition.setLeftExpression((Expression)new Column("1"));
        ignorePermssionCondition.setRightExpression((Expression)new LongValue(1L));
        this.dynaDataPermEnaled = MybatisConfigs.isDataPermissionEnabled(context.getGroupName());
        this.isFieldSharddingTenant = MybatisConfigs.isFieldSharddingTenant(context.getGroupName());
        this.softDeleteColumn = MybatisConfigs.getSoftDeleteColumn(context.getGroupName());
        this.softDeleteFalseValue = MybatisConfigs.getSoftDeletedFalseValue(context.getGroupName());
        this.deptColumnName = MybatisConfigs.getDeptColumnName(context.getGroupName());
        this.createdByColumnName = MybatisConfigs.getCreatedByColumnName(context.getGroupName());
        List<MapperMetadata> mappers = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        if (this.dynaDataPermEnaled) {
            Properties properties = ResourceUtils.getAllProperties((String)"mendmix-cloud.mybatis.dataPermission.columns[");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String tableName = k.toString().substring(k.toString().indexOf(ARRAY_START) + 1).replace("]", "").trim();
                this.buildTableDataPermColumnMapping(tableName, v.toString());
            }));
            Map<String, String> globalDataPermColumnMappings = this.buildGlobalDataPermColumnMapping();
            for (MapperMetadata mapper : mappers) {
                Collection<String> columns = mapper.getPropToColumnMappings().values();
                Optional<Map.Entry> optional = globalDataPermColumnMappings.entrySet().stream().filter(e -> columns.contains(e.getValue())).findFirst();
                if (!optional.isPresent()) continue;
                this.addTableDataPermColumnMappings(mapper.getTableName(), (String)optional.get().getKey(), (String)optional.get().getValue());
            }
            properties = ResourceUtils.getAllProperties((String)"mendmix-cloud.mybatis.dataPermission.orRelationColumns");
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String tableName = null;
                String[] groupValues = StringUtils.split((String)v.toString(), (String)";");
                if (k.toString().contains(ARRAY_START)) {
                    tableName = k.toString().substring(k.toString().indexOf(ARRAY_START) + 1).replace("]", "").trim();
                }
                for (String gv : groupValues) {
                    String[] columns = StringUtils.split((String)gv, (String)",");
                    if (tableName == null) {
                        this.globalOrRelationColumns.add(columns);
                        continue;
                    }
                    List<String[]> list = this.tableOrRelationColumns.get(tableName);
                    if (list == null) {
                        list = new ArrayList<String[]>();
                        this.tableOrRelationColumns.put(tableName, list);
                    }
                    list.add(columns);
                }
            }));
        }
        this.initColumnConfig(mappers, this.softDeleteColumn, null, null);
        this.initColumnConfig(mappers, this.softDeleteColumn, null, this.softDeleteMappedStatements);
        this.initColumnConfig(mappers, this.deptColumnName, null, this.deptMappedStatements);
        if (this.isFieldSharddingTenant) {
            this.tenantColumnName = MybatisConfigs.getTenantColumnName(context.getGroupName());
            for (MapperMetadata mapper : mappers) {
                ColumnMetadata tenantColumn = mapper.getEntityMetadata().getColumnsMapper().stream().filter(o -> o.getColumn().equalsIgnoreCase(this.tenantColumnName)).findFirst().orElse(null);
                if (tenantColumn == null) continue;
                if (this.tenantPropName == null) {
                    this.tenantPropName = tenantColumn.getProperty();
                }
                this.addTableDataPermColumnMappings(mapper.getTableName(), this.tenantPropName, this.tenantColumnName);
            }
        }
        if (this.softDeleteColumn != null && StringUtils.isNumeric((CharSequence)this.softDeleteFalseValue)) {
            for (MapperMetadata mapper : mappers) {
                Optional<ColumnMetadata> optional = mapper.getEntityMetadata().getColumnsMapper().stream().filter(o -> this.softDeleteColumn.equalsIgnoreCase(o.getColumn())).findFirst();
                if (!optional.isPresent()) continue;
                Class<?> javaType = optional.get().getJavaType();
                this.softDeleteFalseValueAsNumber = javaType != String.class && javaType != Character.TYPE;
                break;
            }
        }
        StringBuilder logBuilder = new StringBuilder("<startup-logging>  \nsqlRewrite rules:");
        if (this.isFieldSharddingTenant) {
            logBuilder.append("\n - tenantSharddingColumn:").append(this.tenantColumnName).append(":").append(this.tenantPropName);
        }
        if (this.deptColumnName != null) {
            logBuilder.append("\n - deptColumnName:").append(this.deptColumnName).append(":").append(this.getDeptPropName());
        }
        if (this.createdByColumnName != null) {
            logBuilder.append("\n - createdByColumnName:").append(this.createdByColumnName);
        }
        if (this.softDeleteColumn != null) {
            logBuilder.append("\n - softDeleteColumn:").append(this.softDeleteColumn).append(":").append(this.softDeletePropName);
        }
        if (this.softDeleteFalseValue != null) {
            logBuilder.append("\n - softDeleteFalseValue:").append(this.softDeleteFalseValue);
        }
        logBuilder.append("\n - tableDataPermColumnMappings:").append(this.tableDataPermColumnMappings);
        logBuilder.append("\n - globalOrRelationColumns:").append(JsonUtils.toJson(this.globalOrRelationColumns));
        logBuilder.append("\n - tableOrRelationColumns:").append(JsonUtils.toJson(this.tableOrRelationColumns));
        logger.info(logBuilder.toString());
    }

    private void addTableDataPermColumnMappings(String tableName, String propName, String columnName) {
        List<String> columns;
        if (!this.tableDataPermColumnMappings.containsKey(tableName)) {
            this.tableDataPermColumnMappings.put(tableName, new LinkedHashMap());
        }
        if ((columns = this.tableDataPermColumnMappings.get(tableName).get(propName)) == null) {
            columns = new ArrayList<String>(2);
            this.tableDataPermColumnMappings.get(tableName).put(propName, columns);
        }
        columns.add(columnName);
    }

    private void initColumnConfig(List<MapperMetadata> mappers, String column, List<String> filterTables, List<String> mappedStatements) {
        if (column == null) {
            return;
        }
        ArrayList<String> tmpTables = new ArrayList<String>();
        for (MapperMetadata mapper : mappers) {
            Set<ColumnMetadata> columnsMapping;
            ColumnMetadata columnMetadata;
            if (filterTables != null && !filterTables.contains(mapper.getTableName()) || mapper.getEntityMetadata() == null || (columnMetadata = (ColumnMetadata)(columnsMapping = mapper.getEntityMetadata().getColumnsMapper()).stream().filter(o -> o.getColumn().equals(column)).findFirst().orElse(null)) == null) continue;
            if (column.equals(this.deptColumnName)) {
                this.deptPropName = columnMetadata.getProperty();
            } else if (column.equals(this.softDeleteColumn)) {
                this.softDeletePropName = columnMetadata.getProperty();
            } else if (this.bUnitColumnName.equals(column)) {
                this.bUnitPropName = columnMetadata.getProperty();
            }
            tmpTables.add(mapper.getTableName());
            this.addTableDataPermColumnMappings(mapper.getTableName(), columnMetadata.getProperty(), column);
        }
        if (mappedStatements == null) {
            return;
        }
        for (MapperMetadata mapper : mappers) {
            if (tmpTables.contains(mapper.getTableName())) {
                mappedStatements.add(mapper.getMapperClass().getName());
                continue;
            }
            Set<String> querys = mapper.getQueryTableMappings().keySet();
            block2: for (String query : querys) {
                List<String> tables = mapper.getQueryTableMappings().get(query);
                for (String table : tables) {
                    if (!tmpTables.contains(table)) continue;
                    mappedStatements.add(query);
                    continue block2;
                }
            }
        }
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        if (MybatisRuntimeContext.isIgnoreSqlRewrite()) {
            return null;
        }
        if (invocation.isSelect()) {
            boolean isTableSharding;
            boolean bl = isTableSharding = invocation.getTableNameMapping() != null && !invocation.getTableNameMapping().isEmpty();
            if (!isTableSharding && invocation.isSelectByPrimaryKey()) {
                return null;
            }
            RewriteSqlOnceContext context = this.buildRewriteSqlContext(invocation);
            this.rewriteSelectSql(context);
            if (invocation.getPageObject() != null) {
                return null;
            }
            if (invocation.getSql() == null) {
                String methodName;
                ArrayList<Integer> list = new ArrayList<Integer>(1);
                MapperMetadata entityInfo = invocation.getEntityInfo();
                Class<?> returnType = entityInfo.getMapperMethod(methodName = invocation.getMappedStatement().getId().replace(invocation.getMapperNameSpace(), "").substring(1)).getMethod().getReturnType();
                if (returnType == Integer.TYPE || returnType == Integer.class || returnType == Long.TYPE || returnType == Long.class) {
                    list.add(0);
                }
                return list;
            }
            Executor executor = invocation.getExecutor();
            MappedStatement mappedStatement = invocation.getMappedStatement();
            ResultHandler resultHandler = (ResultHandler)invocation.getArgs()[3];
            List parameterMappings = invocation.getBoundSql().getParameterMappings();
            BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), invocation.getSql(), parameterMappings, invocation.getParameter());
            SqlRewriteHandler.copyAdditionalParameters(invocation.getBoundSql(), newBoundSql);
            CacheKey cacheKey = executor.createCacheKey(mappedStatement, invocation.getParameter(), RowBounds.DEFAULT, newBoundSql);
            List resultList = executor.query(mappedStatement, invocation.getParameter(), RowBounds.DEFAULT, resultHandler, cacheKey, newBoundSql);
            return resultList;
        }
        if (this.rewriteUpdateSql(invocation)) {
            Executor executor = invocation.getExecutor();
            MappedStatement mt = invocation.getMappedStatement();
            List parameterMappings = invocation.getBoundSql().getParameterMappings();
            final BoundSql newBoundSql = new BoundSql(mt.getConfiguration(), invocation.getSql(), parameterMappings, invocation.getParameter());
            SqlRewriteHandler.copyAdditionalParameters(invocation.getBoundSql(), newBoundSql);
            SqlSource sqlSource = new SqlSource(){

                public BoundSql getBoundSql(Object parameterObject) {
                    return newBoundSql;
                }
            };
            if (this.compatibleHandlers != null) {
                for (PluginInterceptorHandler handler : this.compatibleHandlers) {
                    handler.onInterceptor(invocation);
                }
            }
            MappedStatement newMt = new MappedStatement.Builder(mt.getConfiguration(), mt.getId(), sqlSource, mt.getSqlCommandType()).build();
            int updated = executor.update(newMt, invocation.getParameter());
            if (this.compatibleHandlers != null) {
                for (PluginInterceptorHandler handler : this.compatibleHandlers) {
                    handler.onFinished(invocation, updated);
                }
            }
            return updated;
        }
        return null;
    }

    public static void copyAdditionalParameters(BoundSql originBoundSql, BoundSql newBoundSql) {
        List parameterMappings = originBoundSql.getParameterMappings();
        int itemIndex = 0;
        for (ParameterMapping parameterMapping : parameterMappings) {
            Object additionalParamVal;
            if (parameterMapping.getProperty().contains(ARRAY_START)) continue;
            try {
                additionalParamVal = originBoundSql.getAdditionalParameter(parameterMapping.getProperty());
            }
            catch (Exception e) {
                logger.warn(">> get_additionalParamVal_error parameterMappingProperty:{},error:{}", (Object)parameterMapping.getProperty(), (Object)e.getMessage());
                continue;
            }
            if (additionalParamVal == null && !parameterMapping.getProperty().startsWith(FRCH_PREFIX)) continue;
            newBoundSql.setAdditionalParameter(parameterMapping.getProperty(), additionalParamVal);
            if (!parameterMapping.getProperty().startsWith(FRCH_ITEM_PREFIX)) continue;
            String indexParamName = FRCH_INDEX_PREFIX + itemIndex;
            if (!newBoundSql.hasAdditionalParameter(indexParamName)) {
                newBoundSql.setAdditionalParameter(indexParamName, (Object)itemIndex);
            }
            ++itemIndex;
        }
    }

    private void rewriteSelectSql(RewriteSqlOnceContext context) {
        List<String> permGroupKeys;
        String orignSql = context.invocation.getSql();
        String sqlCacheKey = null;
        String rewritedSql = null;
        if (!context.withTableShardingRule()) {
            sqlCacheKey = orignSql + CurrentRuntimeContext.getTenantId();
            rewritedSql = this.getCachingRewritedSql(sqlCacheKey);
        }
        if (StringUtils.isNotBlank(rewritedSql)) {
            context.invocation.setRewriteSql(rewritedSql);
            return;
        }
        if (!context.withConditionReriteRule() && !context.withTableShardingRule()) {
            return;
        }
        Statement statement = MybatisSqlRewriteUtils.parseSql(orignSql);
        if (statement == null) {
            return;
        }
        SelectBody selectBody = ((Select)statement).getSelectBody();
        List<String> list = permGroupKeys = context.handleDataPerm ? context.getPermGroupKeys() : null;
        if (permGroupKeys == null || permGroupKeys.isEmpty()) {
            this.handleSelectRewrite(context, selectBody, false, true);
        } else {
            boolean withAllPermGroup = permGroupKeys.size() == 1 && DeptPermType._ALL_.name().equals(permGroupKeys.get(0));
            for (String groupKey : permGroupKeys) {
                if (!withAllPermGroup) {
                    context.currentGroupKey = groupKey;
                    context.loadedCurrentGroupPermData = false;
                    this.handleSelectRewrite(context, selectBody, true, true);
                    continue;
                }
                context.handleDataPerm = false;
                this.handleSelectRewrite(context, selectBody, true, true);
                context.handleDataPerm = true;
                break;
            }
            for (RewriteTable table : context.rewriteTables) {
                Expression mergeExpression = null;
                Collection<Expression> groupExpressions = table.getGroupExpressions();
                if (groupExpressions == null || groupExpressions.stream().anyMatch(item -> item.equals(ignorePermssionCondition))) continue;
                table.setUsingGlobalOrgPerm(false);
                for (Expression expression : groupExpressions) {
                    expression = this.wrapParenthesis(expression);
                    mergeExpression = mergeExpression == null ? expression : new OrExpression(mergeExpression, expression);
                }
                mergeExpression = this.mergeFinalPermissionExpression(context, table, mergeExpression);
                table.updateConditionExpression(mergeExpression);
            }
        }
        context.invocation.setRewriteSql(selectBody.toString());
        if (sqlCacheKey != null && context.rewriteTables != null && !context.rewriteTables.stream().anyMatch(o -> o.getRewritedTableName() != null)) {
            this.getThreadSqlCache().put(sqlCacheKey, selectBody.toString());
        }
    }

    private boolean rewriteUpdateSql(OnceContextVal invocation) {
        try {
            boolean isTableSharding = invocation.getTableNameMapping() != null && !invocation.getTableNameMapping().isEmpty();
            Map<String, String> rewriteColumns = this.getUpdateRewriteColumns(invocation);
            if (!isTableSharding && (rewriteColumns == null || rewriteColumns.isEmpty())) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)invocation.getSql()) || multiSqlSpiterPattern.matcher(invocation.getSql()).find()) {
                if (isTableSharding) {
                    logger.warn("\nwarn!!!\nwarn!!!\n\u65b9\u6cd5[{}]\u65e0\u6cd5\u89e3\u6790SQL:{},\u5ffd\u7565\u5206\u8868\u5904\u7406!!!!!!", (Object)invocation.getMappedStatement().getId(), (Object)invocation.getSql());
                }
                return false;
            }
            boolean rewrited = false;
            Map<String, String> tableNameMappings = invocation.getTableNameMapping();
            Statement statement = MybatisSqlRewriteUtils.parseSql(invocation.getSql());
            if (statement == null) {
                return false;
            }
            Table table = null;
            if (statement instanceof Update) {
                Expression newWhere;
                Update update = (Update)statement;
                table = update.getTable();
                String tableName = StringUtils.remove((String)table.getName(), (String)RewriteTable.nameDelimiter);
                if (isTableSharding && tableNameMappings.containsKey(tableName)) {
                    table.setName(tableNameMappings.get(tableName));
                    rewrited = true;
                }
                if ((newWhere = this.handleUpdateColumnCondition(table, update.getWhere(), rewriteColumns)) != null) {
                    rewrited = true;
                    update.setWhere(newWhere);
                }
            } else if (statement instanceof Delete) {
                Expression newWhere;
                Delete delete = (Delete)statement;
                table = delete.getTable();
                String tableName = StringUtils.remove((String)table.getName(), (String)RewriteTable.nameDelimiter);
                if (isTableSharding && tableNameMappings.containsKey(tableName)) {
                    table.setName(tableNameMappings.get(tableName));
                    rewrited = true;
                }
                if ((newWhere = this.handleUpdateColumnCondition(table, delete.getWhere(), rewriteColumns)) != null) {
                    rewrited = true;
                    delete.setWhere(newWhere);
                }
            } else if (statement instanceof Insert) {
                Insert insert = (Insert)statement;
                table = insert.getTable();
                String tableName = StringUtils.remove((String)table.getName(), (String)RewriteTable.nameDelimiter);
                if (isTableSharding && tableNameMappings.containsKey(tableName)) {
                    table.setName(tableNameMappings.get(tableName));
                    rewrited = true;
                }
            }
            if (rewrited) {
                invocation.setRewriteSql(statement.toString());
            }
            return rewrited;
        }
        catch (Exception e) {
            logger.error(">> rewriteUpdateSql_ERROR \n -sql:{}\n -reason:{}", (Object)invocation.getSql(), (Object)ExceptionUtils.getRootCauseStackTrace((Throwable)e));
            return false;
        }
    }

    private Map<String, String> getUpdateRewriteColumns(OnceContextVal invocation) {
        MappedStatement mt = invocation.getMappedStatement();
        if (mt.getSqlCommandType().equals((Object)SqlCommandType.INSERT)) {
            return null;
        }
        if (mt.getId().endsWith(CrudMethods.updateByPrimaryKey.name()) || mt.getId().endsWith(CrudMethods.updateByPrimaryKeySelective.name()) || mt.getId().endsWith(CrudMethods.deleteByPrimaryKey.name())) {
            return null;
        }
        MapperMetadata entityInfo = invocation.getEntityInfo();
        if (entityInfo == null) {
            return null;
        }
        Map rewriteColumns = this.tableDataPermColumnMappings.get(entityInfo.getTableName());
        if (rewriteColumns == null || rewriteColumns.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (rewriteColumns.containsKey(this.tenantPropName) && !MybatisRuntimeContext.isIgnoreTenantMode()) {
            map.put(this.tenantPropName, (String)((List)rewriteColumns.get(this.tenantPropName)).get(0));
        }
        if (rewriteColumns.containsKey(this.softDeleteColumn) && !MybatisRuntimeContext.isIgnoreSoftDeleteConditon() && mt.getSqlCommandType().equals((Object)SqlCommandType.UPDATE)) {
            map.put(this.softDeleteColumn, (String)((List)rewriteColumns.get(this.softDeleteColumn)).get(0));
        }
        return map;
    }

    private String getCachingRewritedSql(String sqlCacheKey) {
        if (!ThreadLocalContext.exists((String)SQL_CACHE_KEY)) {
            return null;
        }
        return this.getThreadSqlCache().get(sqlCacheKey);
    }

    private Map<String, String> getThreadSqlCache() {
        Map cache = (Map)ThreadLocalContext.get((String)SQL_CACHE_KEY);
        cache = Optional.ofNullable(cache).orElseGet(() -> {
            HashMap map = new HashMap(5);
            ThreadLocalContext.set((String)SQL_CACHE_KEY, map);
            return map;
        });
        return cache;
    }

    /*
     * WARNING - void declaration
     */
    private void handleSelectRewrite(RewriteSqlOnceContext context, SelectBody selectBody, boolean multiGroupMode, boolean handleWhereSubselect) {
        OnceContextVal invocation = context.invocation;
        if (selectBody instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)selectBody;
            FromItem fromItem = select.getFromItem();
            if (fromItem instanceof Table) {
                if (context.rewriteTables == null) {
                    context.parseRewriteTable(this, select);
                }
                context.loadDataPermValues(this);
                List<RewriteTable> rewriteTables = context.rewriteTables;
                for (RewriteTable rewriteTable : rewriteTables) {
                    if (!rewriteTable.hasRewriteColumn()) continue;
                    Expression newExpression = this.handleTableDataPermission(context, rewriteTable, !multiGroupMode);
                    if (multiGroupMode) {
                        rewriteTable.addGroupExpressions(newExpression);
                        continue;
                    }
                    rewriteTable.updateConditionExpression(newExpression);
                }
                if (!multiGroupMode && context.isHandleGroupOrgPermission()) {
                    void var11_19;
                    if (context.traceLogging) {
                        logger.info("<trace_logging> \u5f00\u59cb\u5904\u7406\u5168\u5c40\u7ec4\u7ec7\u6743\u9650...");
                    }
                    ArrayList<Expression> expressions = new ArrayList<Expression>(rewriteTables.size());
                    for (RewriteTable rewriteTable : rewriteTables) {
                        if (!rewriteTable.isUsingGlobalOrgPerm()) continue;
                        expressions.addAll(this.handleGroupOrgDataPermission(context, rewriteTable));
                    }
                    Object var11_18 = null;
                    for (Expression expression : expressions) {
                        if (expression == null) continue;
                        Expression expression2 = var11_19 == null ? expression : new OrExpression((Expression)var11_19, expression);
                    }
                    if (var11_19 != null) {
                        void var12_28;
                        Expression expression = select.getWhere();
                        if (expression == null) {
                            void var12_26 = var11_19;
                        } else {
                            Parenthesis parenthesis = new Parenthesis((Expression)var11_19);
                            AndExpression andExpression = new AndExpression(expression, (Expression)parenthesis);
                        }
                        select.setWhere((Expression)var12_28);
                    }
                    if (context.traceLogging) {
                        void var11_22;
                        logger.info("<trace_logging> \u5b8c\u6210\u5904\u7406\u5168\u5c40\u7ec4\u7ec7\u6743\u9650,\u91cd\u5199\u65b0\u589e\u6761\u4ef6:{}", (Object)var11_22);
                    }
                }
                if (context.handleOrderBy) {
                    this.handleTableOrderBy(select, (Table)select.getFromItem(), invocation);
                }
            } else if (fromItem instanceof SubSelect) {
                SubSelect subSelect = (SubSelect)fromItem;
                this.handleSelectRewrite(context, subSelect.getSelectBody(), multiGroupMode, true);
            }
            if (handleWhereSubselect && MapperMetadata.getAnnotation(invocation, ConditionWithSubSelect.class) != null) {
                this.handleWhereSubSelect(invocation, select.getWhere(), multiGroupMode);
            }
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList optList = (SetOperationList)selectBody;
            List selects = optList.getSelects();
            for (SelectBody body : selects) {
                if (selects.size() > 1) {
                    context.rewriteTables = null;
                    context.unionSelect = true;
                }
                this.handleSelectRewrite(context, body, multiGroupMode, true);
            }
        }
    }

    private void handleWhereSubSelect(OnceContextVal invocation, Expression expression, boolean multiGroupMode) {
        if (expression instanceof Parenthesis) {
            expression = ((Parenthesis)expression).getExpression();
        }
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            this.handleWhereSubSelect(invocation, leftExpression, multiGroupMode);
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            this.handleWhereSubSelect(invocation, rightExpression, multiGroupMode);
        } else if (expression instanceof InExpression) {
            Expression leftExpression = ((InExpression)expression).getLeftExpression();
            this.handleWhereSubSelect(invocation, leftExpression, multiGroupMode);
            Expression rightExpression = ((InExpression)expression).getRightExpression();
            this.handleWhereSubSelect(invocation, rightExpression, multiGroupMode);
        } else if (expression instanceof ExistsExpression) {
            Expression rightExpression = ((ExistsExpression)expression).getRightExpression();
            this.handleWhereSubSelect(invocation, rightExpression, multiGroupMode);
        } else if (expression instanceof SubSelect) {
            RewriteSqlOnceContext context = this.buildRewriteSqlContext(invocation);
            SubSelect subSelect = (SubSelect)expression;
            if (context.traceLogging) {
                logger.info("<trace_logging> handleWhereSubSelect:{}", (Object)expression);
            }
            this.handleSelectRewrite(context, subSelect.getSelectBody(), multiGroupMode, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Expression handleTableDataPermission(RewriteSqlOnceContext context, RewriteTable rewriteTable, boolean mergeConditon) {
        String[] ownerColumns;
        List<List<ConditionPair>> orConditionGroups;
        Object permExpression = null;
        String tableName = rewriteTable.getTableName();
        DataPermissionStrategy strategy = context.strategy;
        Map<String, String[]> dataMapping = context.getDataPermValues();
        Map<String, List<String>> rewriteColumnMapping = rewriteTable.rewriteColumnMapping;
        Set<String> fieldNames = rewriteColumnMapping.keySet();
        if (context.handleDataPerm && context.currentUser == null) {
            if (context.traceLogging) {
                logger.info("<trace_logging> <\u5904\u7406\u5217\u6743\u9650> currentUser\u4e3a\u7a7a,usingCondition: 1=2");
            }
            return noPermssionCondition;
        }
        if (context.handleDataPerm && MybatisConfigs.DATA_PERM_STRICT_MODE && (dataMapping == null || dataMapping.isEmpty()) && (rewriteTable.getOwnerColumns() == null || rewriteTable.getOwnerColumns().length == 0)) {
            permExpression = noPermssionCondition;
            if (mergeConditon) {
                permExpression = this.mergeFinalPermissionExpression(context, rewriteTable, (Expression)permExpression);
            }
            if (context.traceLogging) {
                logger.info("<trace_logging> <\u5904\u7406\u5217\u6743\u9650> \u65e0\u4efb\u4f55\u6570\u636e\u6743\u9650,usingCondition: 1=2");
            }
            return permExpression;
        }
        List<List<ConditionPair>> list = orConditionGroups = strategy == null ? null : strategy.getOrRelationColumns(tableName);
        if (orConditionGroups == null) {
            orConditionGroups = this.buildRelationColumns(tableName);
        }
        boolean withPermission = false;
        boolean withAllPermission = false;
        String currentTenantId = null;
        ConditionPair condition = null;
        Table table = rewriteTable.getTable();
        for (String string : fieldNames) {
            String[] values;
            if (string.equals(this.softDeletePropName) || rewriteTable.isUsingGlobalOrgPerm() && string.equals(this.deptPropName)) continue;
            condition = null;
            if (context.handleTenant && string.equals(this.tenantPropName)) {
                if (context.mainTableHandledTenant && !rewriteTable.isAppendConditonUsingOn()) continue;
                currentTenantId = CurrentRuntimeContext.getTenantId();
                if (currentTenantId == null) {
                    throw new MendmixBaseException("\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u79df\u6237ID[via:sqlRewrite]");
                }
                values = new String[]{currentTenantId};
                condition = new ConditionPair(this.tenantColumnName, values);
                if (!rewriteTable.isJoin() && !context.unionSelect) {
                    context.mainTableHandledTenant = true;
                }
            } else if (string.equals(this.bUnitPropName)) {
                String businessUnitId = CurrentRuntimeContext.getBusinessUnitId();
                if (businessUnitId == null) continue;
                values = new String[]{businessUnitId};
                condition = new ConditionPair(this.bUnitColumnName, values);
            } else {
                boolean usedOrCondition;
                if (dataMapping == null || !dataMapping.containsKey(string)) continue;
                List<String> columns = rewriteColumnMapping.get(string);
                values = dataMapping.get(string);
                if (values != null && values.length > 0 && DeptPermType._ALL_.name().equals(values[0])) {
                    withAllPermission = true;
                    continue;
                }
                boolean bl = usedOrCondition = orConditionGroups != null;
                if (usedOrCondition) {
                    boolean leastColumnMatched = false;
                    for (List<ConditionPair> conditions : orConditionGroups) {
                        for (ConditionPair pair : conditions) {
                            if (!columns.contains(pair.getColumn())) continue;
                            pair.setValues(values);
                            leastColumnMatched = true;
                        }
                    }
                    usedOrCondition = leastColumnMatched;
                }
                if (!usedOrCondition) {
                    if (columns.size() == 1) {
                        condition = new ConditionPair(columns.get(0), values);
                    } else {
                        if (orConditionGroups == null) {
                            orConditionGroups = new ArrayList<List<ConditionPair>>(2);
                        }
                        ArrayList<ConditionPair> pairs = new ArrayList<ConditionPair>(columns.size());
                        for (String column : columns) {
                            pairs.add(new ConditionPair(column, values));
                        }
                        orConditionGroups.add(pairs);
                    }
                }
                if (!withPermission) {
                    withPermission = true;
                }
            }
            if (condition == null) continue;
            permExpression = this.handleColumnDataPermCondition(rewriteTable, (Expression)permExpression, condition);
        }
        if (orConditionGroups != null) {
            for (List list2 : orConditionGroups) {
                permExpression = this.handleColumnDataPermCondition(table, (Expression)permExpression, list2);
            }
        }
        if ((ownerColumns = rewriteTable.getOwnerColumns()) != null && ownerColumns.length > 0 && (rewriteTable.isOwnerUsingAnd() || !withAllPermission || withPermission)) {
            void var18_25;
            Object var18_21 = null;
            boolean ignoreExistExpression = !withPermission;
            ArrayList<Expression> userScopeExpressions = ownerColumns.length == 1 ? null : new ArrayList<Expression>(ownerColumns.length);
            for (String scopeColumn : ownerColumns) {
                if (rewriteTable.isUsingGlobalOrgPerm() && !this.createdByColumnName.equals(scopeColumn)) continue;
                Expression expression = this.buildCurrentUserDataPermCondition(context, rewriteTable, scopeColumn);
                if (ownerColumns.length <= 1) continue;
                userScopeExpressions.add(expression);
            }
            if (ownerColumns.length > 1) {
                Expression mergeExpression = null;
                for (Expression expression : userScopeExpressions) {
                    if (mergeExpression == null) {
                        mergeExpression = this.wrapParenthesis(expression);
                        continue;
                    }
                    mergeExpression = new OrExpression(mergeExpression, this.wrapParenthesis(expression));
                }
                Expression expression = mergeExpression;
            }
            if (permExpression == null || ignoreExistExpression) {
                permExpression = var18_25;
                ignoreExistExpression = false;
            } else {
                permExpression = rewriteTable.isOwnerUsingAnd() ? new AndExpression(this.wrapParenthesis((Expression)permExpression), this.wrapParenthesis((Expression)var18_25)) : new OrExpression(this.wrapParenthesis((Expression)permExpression), this.wrapParenthesis((Expression)var18_25));
            }
        }
        if (mergeConditon) {
            permExpression = this.mergeFinalPermissionExpression(context, rewriteTable, (Expression)permExpression);
        }
        if (context.handleSoftDelete && rewriteTable.rewriteColumnMapping.containsKey(this.softDeletePropName)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new Column(rewriteTable.getTable(), this.softDeleteColumn));
            if (this.softDeleteFalseValueAsNumber) {
                equalsTo.setRightExpression((Expression)new LongValue(this.softDeleteFalseValue));
            } else {
                equalsTo.setRightExpression((Expression)new StringValue(this.softDeleteFalseValue));
            }
            Object object = permExpression = permExpression == null ? equalsTo : new AndExpression(this.wrapParenthesis((Expression)permExpression), (Expression)equalsTo);
        }
        if (permExpression == null && !withPermission && withAllPermission) {
            permExpression = ignorePermssionCondition;
        }
        if (context.traceLogging) {
            logger.info("<trace_logging> \u5b8c\u6210\u5904\u7406\u8868\uff1a{}\n - \u539f\u6761\u4ef6:{}\n - \u91cd\u5199\u6761\u4ef6:{}", new Object[]{rewriteTable.getTableName(), rewriteTable.getOriginConditionExpression(), permExpression});
        }
        return permExpression;
    }

    private Expression mergeFinalPermissionExpression(RewriteSqlOnceContext context, RewriteTable rewriteTable, Expression permExpression) {
        Expression whereExpression = rewriteTable.getOriginConditionExpression();
        if (whereExpression == null) {
            whereExpression = permExpression;
        } else if (permExpression != null) {
            whereExpression = rewriteTable.getTableStrategy() == null || rewriteTable.getTableStrategy().appendAfter() ? new AndExpression((Expression)new Parenthesis(whereExpression), (Expression)new Parenthesis(permExpression)) : new AndExpression((Expression)new Parenthesis(permExpression), (Expression)new Parenthesis(whereExpression));
        }
        return whereExpression;
    }

    private Expression handleColumnDataPermCondition(RewriteTable table, Expression orginExpression, ConditionPair condition) {
        Column column = new Column(table.getTable(), condition.getColumn());
        String[] values = condition.getValues();
        if (values == null || values.length == 0) {
            if (!MybatisConfigs.DATA_PERM_STRICT_MODE) {
                return orginExpression;
            }
            return noPermssionCondition;
        }
        Object newExpression = orginExpression;
        if (values.length == 1) {
            LikeExpression expression;
            if (values[0].endsWith(QUERY_FUZZY_CHAR)) {
                expression = new LikeExpression();
                expression.setLeftExpression((Expression)column);
                expression.setRightExpression((Expression)new StringValue(values[0]));
            } else {
                expression = new EqualsTo();
                expression.setLeftExpression((Expression)column);
                expression.setRightExpression((Expression)new StringValue(values[0]));
            }
            newExpression = orginExpression == null ? expression : new AndExpression(orginExpression, (Expression)expression);
        } else if (values.length > 1) {
            if (MybatisConfigs.DATA_PERM_ORG_USING_FULL_CODE_MODE && condition.getColumn().equals(this.deptColumnName)) {
                Object groupExpression = null;
                for (String value : values) {
                    LikeExpression itemExpression = new LikeExpression();
                    itemExpression.setLeftExpression((Expression)column);
                    itemExpression.setRightExpression((Expression)new StringValue(value));
                    groupExpression = groupExpression == null ? itemExpression : new OrExpression((Expression)groupExpression, (Expression)itemExpression);
                }
                Parenthesis parenthesis = new Parenthesis(groupExpression);
                newExpression = orginExpression == null ? parenthesis : new AndExpression(orginExpression, (Expression)parenthesis);
            } else {
                ExpressionList expressionList = new ExpressionList(new ArrayList(values.length));
                for (String value : values) {
                    if (value == null) continue;
                    expressionList.getExpressions().add(new StringValue(value));
                }
                if (expressionList.getExpressions().isEmpty()) {
                    newExpression = orginExpression;
                    newExpression = !MybatisConfigs.DATA_PERM_STRICT_MODE ? orginExpression : noPermssionCondition;
                } else {
                    InExpression inExpression = new InExpression((Expression)column, (ItemsList)expressionList);
                    newExpression = orginExpression == null ? inExpression : new AndExpression(orginExpression, (Expression)inExpression);
                }
            }
        }
        return newExpression;
    }

    private Expression handleUpdateColumnCondition(Table table, Expression orginWhere, Map<String, String> rewriteColumns) {
        EqualsTo expression;
        String tenantId;
        if (rewriteColumns == null || rewriteColumns.isEmpty()) {
            return orginWhere;
        }
        AndExpression newWhere = null;
        if (rewriteColumns.containsKey(this.tenantPropName) && (tenantId = CurrentRuntimeContext.getTenantId()) != null) {
            expression = new EqualsTo();
            expression.setLeftExpression((Expression)new Column(table, this.tenantColumnName));
            expression.setRightExpression((Expression)new StringValue(tenantId));
            newWhere = new AndExpression(orginWhere, (Expression)expression);
        }
        if (rewriteColumns.containsKey(this.softDeletePropName)) {
            expression = new EqualsTo();
            expression.setLeftExpression((Expression)new Column(table, this.softDeleteColumn));
            expression.setRightExpression((Expression)new StringValue(this.softDeleteFalseValue));
            newWhere = new AndExpression((Expression)(newWhere == null ? orginWhere : newWhere), (Expression)expression);
        }
        return newWhere;
    }

    private Expression handleColumnDataPermCondition(Table table, Expression orginExpression, List<ConditionPair> orConditions) {
        Expression newExpression;
        Parenthesis groupExpression = null;
        Column column = null;
        int orCount = 0;
        for (ConditionPair condition : orConditions) {
            EqualsTo expression;
            String[] values = condition.getValues();
            if (values == null || values.length == 0) continue;
            column = new Column(table, condition.getColumn());
            if (condition.getValues().length == 1) {
                EqualsTo equalsExpr = new EqualsTo();
                equalsExpr.setLeftExpression((Expression)column);
                equalsExpr.setRightExpression((Expression)new StringValue(values[0]));
                expression = equalsExpr;
            } else {
                ExpressionList expressionList = new ExpressionList(new ArrayList(values.length));
                for (String value : values) {
                    expressionList.getExpressions().add(new StringValue(value));
                }
                expression = new InExpression((Expression)column, (ItemsList)expressionList);
            }
            groupExpression = groupExpression == null ? expression : new OrExpression((Expression)groupExpression, (Expression)expression);
            ++orCount;
        }
        if (orCount == 0) {
            if (!MybatisConfigs.DATA_PERM_STRICT_MODE) {
                return orginExpression;
            }
            return noPermssionCondition;
        }
        if (orCount > 1) {
            groupExpression = new Parenthesis(groupExpression);
        }
        if ((newExpression = orginExpression) == null) {
            newExpression = groupExpression;
        } else if (orCount > 0) {
            newExpression = new AndExpression(newExpression, (Expression)groupExpression);
        }
        return newExpression;
    }

    private List<Expression> handleGroupOrgDataPermission(RewriteSqlOnceContext context, RewriteTable rewriteTable) {
        ArrayList<Expression> expressions = new ArrayList<Expression>(2);
        Expression expression = null;
        String[] permValues = context.getPermValues(this.deptPropName);
        if (permValues != null && rewriteTable.isWithDeptColumn()) {
            ConditionPair condition = new ConditionPair(this.deptColumnName, permValues);
            expression = this.handleColumnDataPermCondition(rewriteTable, null, condition);
            expressions.add(expression);
        }
        if (context.currentUser != null && rewriteTable.getTableStrategy() != null) {
            String[] userScopeColumns;
            for (String column : userScopeColumns = rewriteTable.getTableStrategy().ownerColumns()) {
                if (column.equals(this.createdByColumnName)) continue;
                expression = this.buildCurrentUserDataPermCondition(context, rewriteTable, column);
                expressions.add(expression);
            }
        }
        return expressions;
    }

    private Expression buildCurrentUserDataPermCondition(RewriteSqlOnceContext context, RewriteTable table, String colomnName) {
        EqualsTo expression;
        String currentUserId = MybatisRuntimeContext.getCurrentUserId();
        if (currentUserId == null) {
            throw new MendmixBaseException("\u5f53\u524d\u7528\u6237id\u4e3a\u7a7a");
        }
        EqualsTo userEquals = new EqualsTo();
        userEquals.setLeftExpression((Expression)new Column(table.getTable(), colomnName));
        userEquals.setRightExpression((Expression)new StringValue(currentUserId));
        if (context.currentTenantId != null && table.containsRewriteField(this.tenantPropName)) {
            EqualsTo tenantEquals = new EqualsTo();
            tenantEquals.setLeftExpression((Expression)new Column(table.getTable(), this.tenantColumnName));
            tenantEquals.setRightExpression((Expression)new StringValue(context.currentTenantId));
            expression = new Parenthesis((Expression)new AndExpression((Expression)tenantEquals, (Expression)userEquals));
        } else {
            expression = userEquals;
        }
        return expression;
    }

    private List<List<ConditionPair>> buildRelationColumns(String table) {
        ArrayList<ConditionPair> conditions;
        List<String[]> columnRels = this.tableOrRelationColumns.get(table);
        if (this.globalOrRelationColumns.isEmpty() && columnRels == null) {
            return null;
        }
        ArrayList<List<ConditionPair>> res = new ArrayList<List<ConditionPair>>(this.globalOrRelationColumns.size() + (columnRels == null ? 0 : columnRels.size()));
        if (columnRels != null) {
            for (String[] columns : columnRels) {
                conditions = new ArrayList<ConditionPair>(columns.length);
                for (String column : columns) {
                    conditions.add(new ConditionPair(column, null));
                }
                res.add(conditions);
            }
        }
        for (String[] columns : this.globalOrRelationColumns) {
            conditions = new ArrayList(columns.length);
            for (String column : columns) {
                conditions.add(new ConditionPair(column, null));
            }
            res.add(conditions);
        }
        return res.isEmpty() ? null : res;
    }

    private void handleTableOrderBy(PlainSelect selectBody, Table table, OnceContextVal invocation) {
        Page<?> pageParam = invocation.getPageObject();
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>(pageParam.getOrderBys().size());
        for (OrderBy orderBy : pageParam.getOrderBys()) {
            if (orderBy == null || StringUtils.isBlank((CharSequence)orderBy.getField())) continue;
            MapperMetadata entityInfo = invocation.getEntityInfo();
            String columnName = entityInfo.property2ColumnName(orderBy.getField());
            if (columnName == null && entityInfo.getPropToColumnMappings().values().contains(orderBy.getField())) {
                columnName = orderBy.getField();
            }
            if (columnName == null) {
                logger.warn(">>Column[{}] not found In table[{}]", (Object)orderBy.getField(), (Object)table.getName());
                continue;
            }
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.setAsc(OrderBy.OrderType.ASC.name().equals(orderBy.getSortType()));
            orderByElement.setExpression((Expression)new Column(table, columnName));
            orderByElements.add(orderByElement);
        }
        if (!orderByElements.isEmpty()) {
            selectBody.setOrderByElements(orderByElements);
        }
    }

    public Map<String, List<String>> getTaleAllPermColumnMapping(String tableName) {
        return this.tableDataPermColumnMappings.get(tableName);
    }

    public void mergeTableColumnMapping(Map<String, List<String>> columnMapping, String tableName) {
        if (!this.tableDataPermColumnMappings.containsKey(tableName)) {
            return;
        }
        LinkedHashMap<String, List<String>> map = this.tableDataPermColumnMappings.get(tableName);
        if (this.tenantPropName != null && map.containsKey(this.tenantPropName)) {
            columnMapping.put(this.tenantPropName, map.get(this.tenantPropName));
        }
        if (this.softDeletePropName != null && map.containsKey(this.softDeletePropName)) {
            columnMapping.put(this.softDeletePropName, map.get(this.softDeletePropName));
        }
        if (this.bUnitPropName != null && map.containsKey(this.bUnitPropName)) {
            columnMapping.put(this.bUnitPropName, map.get(this.bUnitPropName));
        }
    }

    private void buildTableDataPermColumnMapping(String tableName, String columnValue) {
        String[] columns;
        for (String column : columns = columnValue.split(",|;")) {
            String[] tmpArr = column.split(":");
            String aliasName = tmpArr.length == 2 ? tmpArr[1] : StringConverter.toCamelCase((String)column);
            this.addTableDataPermColumnMappings(tableName, aliasName, tmpArr[0]);
        }
    }

    private Map<String, String> buildGlobalDataPermColumnMapping() {
        List pairList = ResourceUtils.getList((String)"mendmix-cloud.mybatis.dataPermission.columns");
        HashMap<String, String> map = new HashMap<String, String>(pairList.size());
        for (String pair : pairList) {
            String[] tmpArr = pair.split(":");
            String aliasName = tmpArr.length == 2 ? tmpArr[1] : StringConverter.toCamelCase((String)pair);
            map.put(aliasName, tmpArr[0]);
        }
        return map;
    }

    private RewriteSqlOnceContext buildRewriteSqlContext(OnceContextVal invocation) {
        RewriteSqlOnceContext context = new RewriteSqlOnceContext(invocation, this.isFieldSharddingTenant, this.dynaDataPermEnaled);
        context.handleSoftDelete = !MybatisRuntimeContext.isIgnoreSoftDeleteConditon() && (this.softDeleteMappedStatements.contains(context.invocation.getMapperNameSpace()) || this.softDeleteMappedStatements.contains(context.invocation.getMappedStatement().getId()));
        return context;
    }

    public String getDataPermColumnAlias(String table, String column) {
        String alias = null;
        if (this.tableDataPermColumnMappings.containsKey(table)) {
            alias = this.matchMapKeyByValue((Map<String, List<String>>)this.tableDataPermColumnMappings.get(table), column);
        }
        if (alias == null) {
            alias = StringConverter.toCamelCase((String)column);
        }
        return alias;
    }

    public String getDeptColumnName() {
        return this.deptColumnName;
    }

    public String getDeptPropName() {
        if (this.deptColumnName != null && this.deptPropName == null) {
            this.deptPropName = this.deptColumnName.toUpperCase().equals(this.deptColumnName) ? this.deptColumnName : StringConverter.toCamelCase((String)this.deptColumnName);
        }
        return this.deptPropName;
    }

    public String getCreatedByColumnName() {
        return this.createdByColumnName;
    }

    private Expression wrapParenthesis(Expression expression) {
        if (expression instanceof Parenthesis) {
            return expression;
        }
        return new Parenthesis(expression);
    }

    private String matchMapKeyByValue(Map<String, List<String>> map, String expectValue) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Optional<Map.Entry> optional = map.entrySet().stream().filter(e -> ((List)e.getValue()).contains(expectValue)).findFirst();
        if (optional.isPresent()) {
            return (String)optional.get().getKey();
        }
        return null;
    }

    public boolean matchRewriteStrategy(OnceContextVal invocationVal, Object result) {
        MapperMetadata entityInfo = invocationVal.getEntityInfo();
        if (entityInfo == null) {
            return true;
        }
        try {
            String tenantId = CurrentRuntimeContext.getTenantId();
            if (tenantId != null && this.tenantPropName != null && !MybatisRuntimeContext.isIgnoreTenantMode() && !this.matchFieldValue(entityInfo, result, this.tenantPropName, tenantId)) {
                if (CurrentRuntimeContext.isDebugMode()) {
                    logger.info("<trace_logging> column[{}] not match value:{} !!!", (Object)this.tenantPropName, (Object)tenantId);
                }
                return false;
            }
            if (this.softDeletePropName != null && !MybatisRuntimeContext.isIgnoreSoftDeleteConditon() && !this.matchFieldValue(entityInfo, result, this.softDeletePropName, this.softDeleteFalseValue, Boolean.FALSE.toString())) {
                if (CurrentRuntimeContext.isDebugMode()) {
                    logger.info("<trace_logging> column[{}] is deleted value!!", (Object)this.softDeletePropName);
                }
                return false;
            }
        }
        catch (Exception e) {
            logger.error("matchRewriteStrategy_error", (Throwable)e);
            return true;
        }
        return true;
    }

    private boolean matchFieldValue(MapperMetadata entityInfo, Object object, String fieldName, String ... expectValues) {
        if (entityInfo.getPropToColumnMappings().containsKey(fieldName)) {
            Object actualValue = CachingFieldUtils.readField((Object)object, (String)fieldName);
            if (actualValue == null || StringUtils.isBlank((CharSequence)actualValue.toString())) {
                return true;
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)this.tenantPropName) && "-1".equals(actualValue.toString())) {
                return true;
            }
            for (String val : expectValues) {
                if (!StringUtils.equals((CharSequence)val, (CharSequence)actualValue.toString())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
    }

    @Override
    public int interceptorOrder() {
        return 2;
    }

    @Override
    public void close() {
    }
}

