/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mendmix.cache.CacheUtils;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.model.DataPermItem;

public interface UserPermissionProvider {
    default public List<DataPermItem> findCurrentAllPermissions() {
        String systemId = CurrentRuntimeContext.getSystemId();
        String tenantId = CurrentRuntimeContext.getTenantId();
        String currentUserId = CurrentRuntimeContext.getCurrentUserId();
        if (StringUtils.isBlank((CharSequence)currentUserId)) {
            return new ArrayList<DataPermItem>(0);
        }
        String cacheKey = StringUtils.join((Object[])new String[]{"userDataPerm:", StringUtils.trimToEmpty((String)systemId), "_", StringUtils.trimToEmpty((String)tenantId), "_", currentUserId});
        return (List)CacheUtils.queryTryCache((String)cacheKey, () -> this.findUserPermissions(systemId, tenantId, currentUserId), (long)300L);
    }

    default public List<DataPermItem> findCurrentGroupPermissions() {
        String permGroup = ThreadLocalContext.getStringValue((String)"x-referer-permGroup");
        List<DataPermItem> allPermissions = this.findCurrentAllPermissions();
        if (allPermissions == null) {
            return new ArrayList<DataPermItem>(0);
        }
        if (StringUtils.isBlank((CharSequence)permGroup)) {
            return allPermissions;
        }
        return allPermissions.stream().filter(o -> permGroup.equals(o.getGroupName())).collect(Collectors.toList());
    }

    public List<DataPermItem> findUserPermissions(String var1, String var2, String var3);
}

