/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.rwseparate;

import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RwRouteHandler
implements PluginInterceptorHandler {
    protected static final Logger logger = LoggerFactory.getLogger(RwRouteHandler.class);
    public static final String NAME = "rwRoute";

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        if (MybatisRuntimeContext.isIgnoreRwRoute()) {
            return null;
        }
        MappedStatement ms = invocation.getMappedStatement();
        if (MybatisRuntimeContext.isForceUseMaster()) {
            MybatisRuntimeContext.useMaster();
            logger.debug("<framework-logging> isForceUseMaster for:{}", (Object)ms.getId());
            return null;
        }
        if (ms.getSqlCommandType().equals((Object)SqlCommandType.SELECT)) {
            if (ms.getId().contains("!selectKey")) {
                MybatisRuntimeContext.useMaster();
            } else {
                MybatisRuntimeContext.useSlave();
                logger.debug("<framework-logging> Method[{} use Slave Strategy..", (Object)ms.getId());
            }
        } else {
            logger.debug("<framework-logging> Method[{}] use Master Strategy..", (Object)ms.getId());
            MybatisRuntimeContext.useMaster();
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
    }

    @Override
    public void start(MendmixMybatisInterceptor context) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

