/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.sensitive;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.dromara.mendmix.common.crypt.CustomEncryptor;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.TimeConvertUtils;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.sensitive.annotation.SensitiveField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveCryptHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    public static final String CONTEXT_KEY = "_ctx_sensitiveCrypt";
    private CustomEncryptor encryptor;
    private List<String> defaultFieldNames;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        String cryptKey = ResourceUtils.getProperty((String)"mendmix-cloud.sensitive.cryptKey", (String)(GlobalContext.APPID + GlobalContext.ENV));
        this.encryptor = new CustomEncryptor(cryptKey, false);
        this.defaultFieldNames = ResourceUtils.containsProperty((String)"mendmix-cloud.sensitive.defaultFieldNames") ? ResourceUtils.getList((String)"mendmix-cloud.sensitive.defaultFieldNames") : ResourceUtils.getList((String)"mendmix-cloud.mybatis.sensitive.defaultFieldNames");
        logger.info("SensitiveCrypt defaultFieldNames -> {}", this.defaultFieldNames);
    }

    @Override
    public void close() {
    }

    @Override
    public Object onInterceptor(OnceContextVal invocationVal) throws Throwable {
        if (!ThreadLocalContext.exists((String)CONTEXT_KEY)) {
            return null;
        }
        MappedStatement statement = invocationVal.getMappedStatement();
        if (statement.getSqlCommandType() == SqlCommandType.INSERT || statement.getSqlCommandType() == SqlCommandType.UPDATE) {
            this.handleObjectEncryt(invocationVal.getParameter());
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocationVal, Object result) {
        if (!ThreadLocalContext.exists((String)CONTEXT_KEY)) {
            return;
        }
        if (!invocationVal.isSelect() || invocationVal.getMappedStatement().getId().contains("!selectKey")) {
            return;
        }
        try {
            this.handleObjectDecrypt(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int interceptorOrder() {
        return 2;
    }

    private void handleObjectDecrypt(Object o) throws Exception {
        if (o == null || BeanUtils.isSimpleDataType((Object)o)) {
            return;
        }
        if (o instanceof Collection) {
            Collection list = (Collection)o;
            for (Object object : list) {
                this.handleObjectDecrypt(object);
            }
        } else {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(o.getClass())) {
                Object value;
                if (field.isEnumConstant()) continue;
                if (Collection.class.isAssignableFrom(field.getType())) {
                    field.setAccessible(true);
                    value = field.get(o);
                    if (value == null) continue;
                    for (Object object : (Collection)value) {
                        this.handleObjectDecrypt(object);
                    }
                    continue;
                }
                if (field.isAnnotationPresent(SensitiveField.class)) {
                    field.setAccessible(true);
                    value = field.get(o);
                    String valueString = Objects.toString(value, null);
                    if (StringUtils.isBlank((CharSequence)valueString) || !valueString.startsWith("{Cipher}")) continue;
                    value = this.encryptor.decrypt(valueString);
                    field.set(o, value);
                    continue;
                }
                if (BeanUtils.isSimpleDataType(field.getType())) continue;
                field.setAccessible(true);
                value = field.get(o);
                this.handleObjectDecrypt(value);
            }
        }
    }

    private void handleObjectEncryt(Object parameter) {
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            if (map.containsKey("arg0")) {
                this.handleObjectItemEncrypt(map.get("arg0"));
            } else {
                for (Object object : map.values()) {
                    this.handleObjectItemEncrypt(object);
                }
            }
        } else if (parameter instanceof Collection) {
            for (Object object : (Collection)parameter) {
                this.handleObjectItemEncrypt(object);
            }
        } else {
            this.handleObjectItemEncrypt(parameter);
        }
    }

    private void handleObjectItemEncrypt(Object parameter) {
        if (BeanUtils.isSimpleDataType((Object)parameter)) {
            return;
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            for (String fieldName : this.defaultFieldNames) {
                Object value = map.get(fieldName);
                if (value == null) continue;
                if (value instanceof Date) {
                    value = TimeConvertUtils.toUTC((Date)((Date)value));
                    map.put(fieldName, value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                value = TimeConvertUtils.toUTC((String)value.toString());
                map.put(fieldName, value);
            }
        } else if (parameter instanceof Collection) {
            for (Object object : (Collection)parameter) {
                this.handleObjectItemEncrypt(object);
            }
        } else {
            List fields = FieldUtils.getFieldsListWithAnnotation(parameter.getClass(), SensitiveField.class);
            for (Object field : fields) {
                ((Field)field).setAccessible(true);
            }
            if (!this.defaultFieldNames.isEmpty()) {
                for (String fieldName : this.defaultFieldNames) {
                    Field field = FieldUtils.getField(parameter.getClass(), (String)fieldName, (boolean)true);
                    if (field == null) continue;
                    fields.add(field);
                }
            }
            for (Object field : fields) {
                try {
                    Object value = ((Field)field).get(parameter);
                    String valueString = Objects.toString(value, null);
                    if (StringUtils.isBlank((CharSequence)valueString) || valueString.startsWith("{Cipher}")) continue;
                    value = this.encryptor.encrypt(valueString);
                    ((Field)field).set(parameter, value);
                }
                catch (Exception e) {
                    logger.error("[" + ((Field)field).getName() + "]\u52a0\u5bc6\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }
}

