/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.shard;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.shard.TableShardingScope;
import org.dromara.mendmix.mybatis.plugin.shard.TableShardingStrategy;
import org.dromara.mendmix.mybatis.plugin.shard.annotation.TableSharding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableShardingHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    public static final String NAME = "tableSharding";
    private Map<String, TableShardingStrategy> tableStrategyMapping = new HashMap<String, TableShardingStrategy>();
    private Map<String, Map<String, TableShardingStrategy>> methodStrategyMapping = new HashMap<String, Map<String, TableShardingStrategy>>();

    @Override
    public void start(MendmixMybatisInterceptor context) {
        List tableNames = ResourceUtils.getList((String)"mendmix-cloud.mybatis.tableshard.tableNames");
        Class<?> defStrategyClass = null;
        if (ResourceUtils.containsProperty((String)"mendmix-cloud.mybatis.tableshard.defaultStrategy")) {
            try {
                defStrategyClass = Class.forName(ResourceUtils.getProperty((String)"mendmix-cloud.mybatis.tableshard.defaultStrategy"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(context.getGroupName());
        HashMap<String, TableShardingStrategy> strategyInstances = new HashMap<String, TableShardingStrategy>();
        for (MapperMetadata ei : entityInfos) {
            Class<Object> strategyClass;
            if (!tableNames.contains(ei.getTableName()) && !ei.getEntityClass().isAnnotationPresent(TableSharding.class) || (strategyClass = ei.getEntityClass().isAnnotationPresent(TableSharding.class) ? ei.getEntityClass().getAnnotation(TableSharding.class).strategy() : defStrategyClass) == null) continue;
            TableShardingStrategy strategy = (TableShardingStrategy)strategyInstances.get(strategyClass.getName());
            if (strategy == null) {
                try {
                    strategy = (TableShardingStrategy)strategyClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                strategyInstances.put(strategyClass.getName(), strategy);
            }
            this.tableStrategyMapping.put(ei.getTableName(), strategy);
        }
        for (MapperMetadata ei : entityInfos) {
            Map<String, List<String>> queryTableMappings = ei.getQueryTableMappings();
            Set<String> querys = queryTableMappings.keySet();
            for (String query : querys) {
                List<String> tables = ei.getQueryTableMappings().get(query);
                for (String table : tables) {
                    if (!this.tableStrategyMapping.containsKey(table)) continue;
                    if (!this.methodStrategyMapping.containsKey(query)) {
                        this.methodStrategyMapping.put(query, new HashMap());
                    }
                    this.methodStrategyMapping.get(query).put(table, this.tableStrategyMapping.get(table));
                }
            }
            Collection<MapperMetadata.MapperMethod> methods = ei.getMapperMethods().values();
            for (MapperMetadata.MapperMethod method : methods) {
                String[] defTables;
                if (!method.getMethod().isAnnotationPresent(TableShardingScope.class)) continue;
                if (!this.methodStrategyMapping.containsKey(method.getFullName())) {
                    this.methodStrategyMapping.put(method.getFullName(), new HashMap());
                }
                for (String table : defTables = method.getMethod().getAnnotation(TableShardingScope.class).tables()) {
                    if (this.tableStrategyMapping.containsKey(table)) {
                        this.methodStrategyMapping.get(method.getFullName()).put(table, this.tableStrategyMapping.get(table));
                        continue;
                    }
                    logger.warn(">>TableShardingStrategy NOT FOUND for:{}", (Object)table);
                }
            }
        }
        logger.info(">>TableSharding rules >> \ntable:\n -{} \nmethod:\n -{}", this.tableStrategyMapping.keySet(), this.methodStrategyMapping.keySet());
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        TableShardingStrategy strategy;
        if (MybatisRuntimeContext.isIgnoreTableSharding()) {
            return null;
        }
        HashMap<String, String> tableNameMapping = null;
        Map<String, TableShardingStrategy> map = this.methodStrategyMapping.get(invocation.getMappedStatement().getId());
        if (map != null && !map.isEmpty()) {
            tableNameMapping = new HashMap(map.size());
            for (String tableName : map.keySet()) {
                strategy = map.get(tableName);
                String rewritedTableName = strategy.buildShardingTableName(tableName, invocation);
                if (rewritedTableName == null || rewritedTableName.equalsIgnoreCase(tableName)) continue;
                tableNameMapping.put(tableName, rewritedTableName);
            }
        }
        if (tableNameMapping == null) {
            String rewritedTableName;
            tableNameMapping = new HashMap<String, String>(1);
            MapperMetadata mapperMeta = invocation.getEntityInfo();
            if (mapperMeta != null && this.tableStrategyMapping.containsKey(mapperMeta.getTableName()) && (rewritedTableName = (strategy = this.tableStrategyMapping.get(mapperMeta.getTableName())).buildShardingTableName(mapperMeta.getTableName(), invocation)) != null && !rewritedTableName.equalsIgnoreCase(mapperMeta.getTableName())) {
                tableNameMapping.put(mapperMeta.getTableName(), rewritedTableName);
            }
        }
        if (tableNameMapping != null && !tableNameMapping.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug(">> Mapper[{}] matched tableSharding mapping:{}", (Object)invocation.getMappedStatement().getId(), tableNameMapping);
            }
            invocation.setTableNameMapping(tableNameMapping);
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocation, Object result) {
    }

    @Override
    public void close() {
    }

    @Override
    public int interceptorOrder() {
        return 1;
    }
}

