/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.plugin.timezone;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.mapping.SqlCommandType;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.util.BeanUtils;
import org.dromara.mendmix.common.util.DateUtils;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.common.util.TimeConvertUtils;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.dromara.mendmix.mybatis.plugin.OnceContextVal;
import org.dromara.mendmix.mybatis.plugin.PluginInterceptorHandler;
import org.dromara.mendmix.mybatis.plugin.timezone.annotation.UTCTimeConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZoneConvertHandler
implements PluginInterceptorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    public static final String CONTEXT_KEY = "_ctx_timeZoneConvert";
    private static Pattern paramPattern = Pattern.compile("param[1-9]{1}");
    private List<String> defaultFieldNames;

    @Override
    public void start(MendmixMybatisInterceptor context) {
        this.defaultFieldNames = ResourceUtils.containsProperty((String)"mendmix-cloud.timezone.convert.defaultFieldNames") ? ResourceUtils.getList((String)"mendmix-cloud.timezone.convert.defaultFieldNames") : ResourceUtils.getList((String)"mendmix-cloud.mybatis.timezone.convert.defaultFieldNames");
        logger.info("TimeZoneConvert defaultFieldNames -> {}", this.defaultFieldNames);
    }

    @Override
    public void close() {
    }

    @Override
    public Object onInterceptor(OnceContextVal invocation) throws Throwable {
        if (invocation.getMappedStatement().getSqlCommandType() == SqlCommandType.DELETE) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} handleTimeToUTC Begin....", (Object)invocation.getMappedStatement().getId());
        }
        boolean updateAction = invocation.getMappedStatement().getSqlCommandType() == SqlCommandType.UPDATE;
        Object parameter = invocation.getParameter();
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            if (map.containsKey("arg0")) {
                this.handleTimeToUTC(map.get("arg0"), updateAction);
            } else {
                for (String key : map.keySet()) {
                    if (paramPattern.matcher(key).matches()) continue;
                    this.handleTimeToUTC(map.get(key), updateAction);
                }
            }
        } else if (parameter instanceof Collection) {
            for (Object object : (Collection)parameter) {
                this.handleTimeToUTC(object, updateAction);
            }
        } else {
            this.handleTimeToUTC(parameter, updateAction);
        }
        return null;
    }

    @Override
    public void onFinished(OnceContextVal invocationVal, Object result) {
        String timeZone;
        if (!invocationVal.isSelect() || invocationVal.getMappedStatement().getId().contains("!selectKey")) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} handleReverseFromUTC Begin....", (Object)invocationVal.getMappedStatement().getId());
        }
        if (StringUtils.isNotBlank((CharSequence)(timeZone = CurrentRuntimeContext.getTimeZone()))) {
            try {
                this.handleReverseFromUTC(result, timeZone);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int interceptorOrder() {
        return 2;
    }

    private void handleTimeToUTC(Object parameter, boolean updateAction) {
        if (BeanUtils.isSimpleDataType((Object)parameter)) {
            return;
        }
        if (parameter instanceof Map) {
            Map map = (Map)parameter;
            for (String fieldName : this.defaultFieldNames) {
                Object value = map.get(fieldName);
                if (value == null) continue;
                if (value instanceof Date) {
                    value = TimeConvertUtils.toUTC((Date)((Date)value));
                    map.put(fieldName, value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                value = TimeConvertUtils.toUTC((String)value.toString());
                map.put(fieldName, value);
            }
        } else if (parameter instanceof Collection) {
            for (Object object : (Collection)parameter) {
                this.handleTimeToUTC(object, updateAction);
            }
        } else {
            Field[] fields = FieldUtils.getAllFields(parameter.getClass());
            Date date = new Date();
            for (Field field : fields) {
                if (field.isAnnotationPresent(UTCTimeConvert.class)) {
                    UTCTimeConvert annotation = field.getAnnotation(UTCTimeConvert.class);
                    if (TimeConvertUtils.isSystemDefaultUTC() && annotation.systemTime()) continue;
                    field.setAccessible(true);
                    this.doConvertUTC(parameter, field, date, annotation.systemTime(), updateAction);
                    continue;
                }
                if (TimeConvertUtils.isSystemDefaultUTC() || !this.defaultFieldNames.contains(field.getName())) continue;
                field.setAccessible(true);
                this.doConvertUTC(parameter, field, date, true, updateAction);
            }
        }
    }

    private void handleReverseFromUTC(Object o, String timeZone) throws Exception {
        if (o == null || BeanUtils.isSimpleDataType((Object)o)) {
            return;
        }
        if (o instanceof Collection) {
            Collection list = (Collection)o;
            for (Object object : list) {
                this.handleReverseFromUTC(object, timeZone);
            }
        } else {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(o.getClass())) {
                Object value;
                if (field.isEnumConstant()) continue;
                if (Collection.class.isAssignableFrom(field.getType())) {
                    field.setAccessible(true);
                    value = field.get(o);
                    if (value == null) continue;
                    for (Object object : (Collection)value) {
                        this.handleReverseFromUTC(object, timeZone);
                    }
                    continue;
                }
                if (field.isAnnotationPresent(UTCTimeConvert.class) || this.defaultFieldNames.contains(field.getName())) {
                    field.setAccessible(true);
                    value = field.get(o);
                    if (value == null || StringUtils.isBlank((CharSequence)value.toString())) continue;
                    value = value instanceof Date ? TimeConvertUtils.reverseFromUTC((Date)((Date)value), (String)timeZone) : TimeConvertUtils.reverseFromUTC((String)value.toString(), (String)timeZone);
                    field.set(o, value);
                    continue;
                }
                if (BeanUtils.isSimpleDataType(field.getType())) continue;
                field.setAccessible(true);
                value = field.get(o);
                this.handleReverseFromUTC(value, timeZone);
            }
        }
    }

    private void doConvertUTC(Object o, Field field, Date currentTime, boolean isSystemTime, boolean isUpdate) {
        try {
            Object value = field.get(o);
            if (value == null) {
                return;
            }
            String timeZone = CurrentRuntimeContext.getTimeZone();
            Date utcDate = null;
            if (value instanceof Date) {
                if (isSystemTime) {
                    if (isUpdate && StringUtils.isNotBlank((CharSequence)timeZone) && DateUtils.getDiffSeconds((Date)currentTime, (Date)((Date)value)) > 600L) {
                        utcDate = TimeConvertUtils.toUTC((Date)((Date)value), (String)timeZone);
                    } else if (!TimeConvertUtils.isSystemDefaultUTC()) {
                        utcDate = TimeConvertUtils.toUTC((Date)((Date)value));
                    }
                } else if (StringUtils.isNotBlank((CharSequence)timeZone)) {
                    utcDate = TimeConvertUtils.toUTC((Date)((Date)value), (String)timeZone);
                }
                if (utcDate != null) {
                    field.set(o, utcDate);
                    if (logger.isDebugEnabled()) {
                        logger.debug(">> Convert {}.{} oldValue:{},newValue:{},isSystemTime:{}", new Object[]{o.getClass().getSimpleName(), field.getName(), value, utcDate, isSystemTime});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("[" + field.getName() + "]\u65f6\u533a\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
    }
}

