/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.spring;

import java.lang.reflect.Method;
import java.util.List;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.model.AuthUser;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.MybatisRuntimeContext;
import org.dromara.mendmix.mybatis.datasource.UsingDataSource;
import org.dromara.mendmix.mybatis.plugin.operProtect.annotation.SensitiveOperProtect;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DataPermission;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.DatapermissionIgnore;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.SofeDeleteIgnore;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.SqlRewriteIgnore;
import org.dromara.mendmix.mybatis.plugin.rewrite.annotation.TenantRouteIgnore;
import org.dromara.mendmix.mybatis.plugin.rwseparate.UseMaster;
import org.dromara.mendmix.spring.InterceptorHanlder;
import org.springframework.transaction.annotation.Transactional;

public class MyBatisInterceptorHandler
implements InterceptorHanlder {
    private List<String> ignoreTenantUserTypes = ResourceUtils.getList((String)"mendmix-cloud.mybatis.tenant.ignoreUserType");

    public void preHandler(Method method, Object[] args) {
        AuthUser currentUser;
        if (!MybatisRuntimeContext.isTransactionalOn() && method.isAnnotationPresent(Transactional.class)) {
            boolean readOnly = method.getAnnotation(Transactional.class).readOnly();
            MybatisRuntimeContext.setTransactionalMode(!readOnly);
        }
        if (method.isAnnotationPresent(UseMaster.class)) {
            MybatisRuntimeContext.forceUseMaster();
        }
        if (method.isAnnotationPresent(TenantRouteIgnore.class)) {
            MybatisRuntimeContext.setIgnoreTenantMode();
        } else if (!MybatisRuntimeContext.isIgnoreTenantMode() && (currentUser = CurrentRuntimeContext.getCurrentUser()) != null && this.ignoreTenantUserTypes.contains(currentUser.getType())) {
            MybatisRuntimeContext.setIgnoreTenantMode();
        }
        if (method.isAnnotationPresent(DataPermission.class)) {
            MybatisRuntimeContext.setDataPermissionStrategy(method.getAnnotation(DataPermission.class));
        }
        if (method.isAnnotationPresent(SqlRewriteIgnore.class)) {
            MybatisRuntimeContext.setIgnoreSqlRewrite(true);
        }
        if (method.isAnnotationPresent(DatapermissionIgnore.class)) {
            MybatisRuntimeContext.setIgnoreDataPermission(true);
        }
        if (method.isAnnotationPresent(SofeDeleteIgnore.class)) {
            MybatisRuntimeContext.setIgnoreSoftDeleteConditon(true);
        }
        if (method.isAnnotationPresent(UsingDataSource.class)) {
            UsingDataSource annotation = method.getAnnotation(UsingDataSource.class);
            MybatisRuntimeContext.setDatasourceGroup(annotation.group());
            if (annotation.dataSourceKey().length > 0) {
                MybatisRuntimeContext.setTenantDataSourceKey(annotation.dataSourceKey()[0]);
            }
        }
        if (method.isAnnotationPresent(SensitiveOperProtect.class)) {
            SensitiveOperProtect annotation = method.getAnnotation(SensitiveOperProtect.class);
            MybatisRuntimeContext.setIgnoreOperProtect(annotation.value());
        }
    }

    public void postHandler(Object result, Exception ex) {
    }

    public int priority() {
        return 0;
    }
}

