/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.spring;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.dromara.mendmix.mybatis.crud.GeneralSqlGenerator;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.metadata.MapperMetadata;
import org.dromara.mendmix.mybatis.plugin.MendmixMybatisInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisEnhanceHelper {
    private static final Logger logger = LoggerFactory.getLogger(MybatisEnhanceHelper.class);

    public static void handle(String group, Configuration configuration) throws Exception {
        try {
            Class<?> helperClazz = Class.forName("tk.mybatis.mapper.mapperhelper.MapperHelper");
            Object helper = helperClazz.newInstance();
            Class<?> configClazz = Class.forName("tk.mybatis.mapper.entity.Config");
            Object config = configClazz.newInstance();
            Method method = configClazz.getDeclaredMethod("setNotEmpty", Boolean.TYPE);
            method.invoke(config, false);
            method = helperClazz.getDeclaredMethod("setConfig", configClazz);
            method.invoke(helper, config);
            method = helperClazz.getDeclaredMethod("registerMapper", Class.class);
            List<MapperMetadata> entityInfos = MybatisMapperParser.getMapperMetadatas(group);
            for (MapperMetadata entityInfo : entityInfos) {
                method.invoke(helper, entityInfo.getMapperClass());
            }
            method = helperClazz.getDeclaredMethod("processConfiguration", Configuration.class);
            method.invoke(helper, configuration);
            logger.info(">> register [tk.mybatis.mapper.mapperhelper.MapperHelper] for group:{} finish,mapperNums:{}", (Object)group, (Object)entityInfos.size());
        }
        catch (ClassNotFoundException e) {
            new GeneralSqlGenerator(group, configuration).generate();
        }
        catch (Exception e) {
            throw e;
        }
        try {
            Class<?> pageHelperClazz = Class.forName("com.github.pagehelper.PageInterceptor");
            Interceptor pageInterceptor = (Interceptor)pageHelperClazz.newInstance();
            configuration.addInterceptor(pageInterceptor);
        }
        catch (Exception pageHelperClazz) {
            // empty catch block
        }
        MendmixMybatisInterceptor interceptor = new MendmixMybatisInterceptor(group);
        configuration.addInterceptor((Interceptor)interceptor);
        interceptor.afterRegister();
        logger.info(">> JeesuiteMybatisEnhancer finshed -> group:{}", (Object)group);
        List interceptors = configuration.getInterceptors();
        for (Interceptor inter : interceptors) {
            logger.info(">> Add Mybaits Interceptor:{}", (Object)inter.getClass().getName());
        }
    }
}

