/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.mybatis.spring;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.Configuration;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.dromara.mendmix.mybatis.datasource.DataSourceConfig;
import org.dromara.mendmix.mybatis.kit.MybatisMapperParser;
import org.dromara.mendmix.mybatis.spring.MybatisEnhanceHelper;
import org.dromara.mendmix.spring.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SqlSessionFactoryBean
extends org.mybatis.spring.SqlSessionFactoryBean
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.mybatis");
    private String groupName = "default";
    private Resource[] mapperLocations;

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setMapperLocations(Resource ... mapperLocations) {
        Resource[] adapterMapperLocations = this.getAdapterMapperLocations();
        if (adapterMapperLocations != null && adapterMapperLocations.length > 0) {
            String fileName;
            HashMap<String, Resource> mapperResourceMap = new HashMap<String, Resource>(mapperLocations.length);
            for (Resource resource : mapperLocations) {
                fileName = resource.getFilename();
                mapperResourceMap.put(fileName, resource);
            }
            for (Resource resource : adapterMapperLocations) {
                fileName = resource.getFilename();
                Resource originResource = (Resource)mapperResourceMap.get(fileName);
                if (originResource == null) continue;
                Resource mergedResource = this.mergeMapperResource(originResource, resource);
                mapperResourceMap.put(fileName, mergedResource);
                logger.info(">>load adapter mapper:{},location:{}", (Object)fileName, (Object)resource);
            }
            mapperLocations = mapperResourceMap.values().toArray(new Resource[0]);
        }
        this.mapperLocations = mapperLocations;
        super.setMapperLocations(mapperLocations);
    }

    private Resource[] getAdapterMapperLocations() {
        String mapperLocationsValue;
        String mapperAdapter;
        if (DataSourceConfig.DEFAULT_GROUP_NAME.equals(this.groupName)) {
            mapperAdapter = ResourceUtils.getProperty((String)"mybatis.mapper-adapter");
            mapperLocationsValue = ResourceUtils.getProperty((String)"mybatis.mapper-locations");
        } else {
            mapperAdapter = ResourceUtils.getAnyProperty((String[])new String[]{this.groupName + ".mybatis.mapper-adapter", "group[" + this.groupName + "].mybatis.mapper-adapter"});
            mapperLocationsValue = ResourceUtils.getAnyProperty((String[])new String[]{this.groupName + ".mybatis.mapper-locations", "group[" + this.groupName + "].mybatis.mapper-locations"});
        }
        if (StringUtils.isBlank((CharSequence)mapperAdapter)) {
            return null;
        }
        logger.info(">>mybatis mapperAdapter::{}", (Object)mapperAdapter);
        String[] mapperLocations = StringUtils.split((String)mapperLocationsValue, (String)",");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Object[] allResources = null;
        for (String mapperLocation : mapperLocations) {
            String[] parts = StringUtils.split((String)mapperLocation, (String)":", (int)2);
            String path = parts[1];
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String adapterMapperLocations = parts[0] + ":" + mapperAdapter + "-" + path;
            try {
                Object[] resources = resolver.getResources(adapterMapperLocations);
                if (allResources == null) {
                    allResources = resources;
                    continue;
                }
                allResources = (Resource[])ArrayUtils.addAll((Object[])allResources, (Object[])resources);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return allResources;
    }

    private Resource mergeMapperResource(Resource originResource, Resource newResource) {
        try {
            String key;
            Element child;
            SAXReader saxReader = new SAXReader();
            Document originDocument = saxReader.read(originResource.getInputStream());
            Element root = originDocument.getRootElement();
            Iterator iterator = root.elementIterator();
            HashMap<String, Element> map = new HashMap<String, Element>();
            while (iterator.hasNext()) {
                child = (Element)iterator.next();
                key = child.getName() + "-" + child.attributeValue("id");
                map.put(key, child);
            }
            Document newDocument = saxReader.read(newResource.getInputStream());
            root = newDocument.getRootElement();
            iterator = root.elementIterator();
            while (iterator.hasNext()) {
                child = (Element)iterator.next();
                key = child.getName() + "-" + child.attributeValue("id");
                if (!map.containsKey(key)) continue;
                Element originElement = (Element)map.get(key);
                originElement.setContent(((DefaultElement)child).content());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, OutputFormat.createPrettyPrint());
            writer.write(originDocument);
            writer.close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        MybatisMapperParser.addMapperLocations(this.groupName, this.mapperLocations);
        Configuration configuration = this.getObject().getConfiguration();
        MybatisEnhanceHelper.handle(this.groupName, configuration);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        InstanceFactory.setApplicationContext((ApplicationContext)applicationContext);
    }
}

