/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.spring;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.mendmix.spring.helper.EnvironmentHelper;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class InstanceFactory {
    private static ApplicationContext applicationContext;
    private static Long timeStarting;
    private static AtomicBoolean initialized;
    private static AtomicBoolean loadFinished;

    public static void setApplicationContext(ApplicationContext applicationContext) {
        if (InstanceFactory.applicationContext != null) {
            return;
        }
        InstanceFactory.applicationContext = applicationContext;
        initialized.set(true);
        EnvironmentHelper.init(applicationContext);
    }

    public static void loadFinished() {
        loadFinished.set(true);
    }

    public static boolean isLoadfinished() {
        return loadFinished.get();
    }

    public static ApplicationContext getContext() {
        return applicationContext;
    }

    public static DefaultListableBeanFactory getBeanFactory() {
        return (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
    }

    public static <T> T getInstance(Class<T> beanClass) {
        String[] beanNames = applicationContext.getBeanNamesForType(beanClass);
        if (beanNames.length == 0) {
            return null;
        }
        return (T)applicationContext.getBean(beanNames[0]);
    }

    public static <T> T getInstance(Class<T> beanClass, String beanName) {
        return (T)applicationContext.getBean(beanName, beanClass);
    }

    public static <T> T getByBeanName(String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getInstance(String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    @Deprecated
    public static <T> int getInterfaceCount(Class<T> beanClass) {
        return InstanceFactory.getBeanCountOfType(beanClass);
    }

    @Deprecated
    public static <T> Map<String, T> getInterfaces(Class<T> beanClass) {
        return InstanceFactory.getBeansOfType(beanClass);
    }

    public static <T> int getBeanCountOfType(Class<T> beanClass) {
        return applicationContext.getBeanNamesForType(beanClass).length;
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> beanClass) {
        return applicationContext.getBeansOfType(beanClass);
    }

    public static synchronized void waitUtilInitialized() {
        if (initialized.get()) {
            return;
        }
        while (!initialized.get()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long waiting = System.currentTimeMillis() - timeStarting;
            if (waiting > 60000L) {
                throw new RuntimeException("Spring Initialize failture");
            }
            System.out.println("Spring Initializing >>>>>" + waiting + " s");
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    static {
        timeStarting = System.currentTimeMillis();
        initialized = new AtomicBoolean(false);
        loadFinished = new AtomicBoolean(false);
    }
}

