/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.spring.autoconfigure;

import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import org.dromara.mendmix.common.CurrentRuntimeContext;
import org.dromara.mendmix.common.MendmixBaseException;
import org.dromara.mendmix.common.ThreadLocalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AsyncTaskExecutorConfigurer
implements AsyncConfigurer {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix");
    @Value(value="${spring.customize.asyncExecutor.corePoolSize:1}")
    private int corePoolSize;
    @Value(value="${spring.customize.asyncExecutor.maxPoolSize:20}")
    private int maxPoolSize;
    @Value(value="${spring.customize.asyncExecutor.queueCapacity:1000}")
    private int queueCapacity;
    private static RejectedExecutionHandler REJECT_HANDLER = (r, e) -> {
        String name = Thread.currentThread().getName();
        logger.warn(">>AsyncTaskExecutor Rejected for:{},status:{}", (Object)name, (Object)e.toString());
        throw new MendmixBaseException("\u5f02\u6b65\u4efb\u52a1\u961f\u5217\u5df2\u6ee1");
    };
    private static TaskDecorator TASK_DECORATOR = runnable -> {
        Map allContextVars = CurrentRuntimeContext.getContextHeaders();
        return () -> {
            try {
                logger.debug(">>AsyncTaskExecutor CurrentRuntimeContext: {}", (Object)allContextVars);
                allContextVars.forEach(ThreadLocalContext::set);
                runnable.run();
            }
            finally {
                ThreadLocalContext.unset();
            }
        };
    };

    public ThreadPoolTaskExecutor getAsyncExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setThreadNamePrefix("springAsyncTask-");
        taskExecutor.setCorePoolSize(this.corePoolSize);
        taskExecutor.setMaxPoolSize(this.maxPoolSize);
        taskExecutor.setQueueCapacity(this.queueCapacity);
        taskExecutor.setRejectedExecutionHandler(REJECT_HANDLER);
        taskExecutor.setTaskDecorator(TASK_DECORATOR);
        taskExecutor.setTaskDecorator(TASK_DECORATOR);
        taskExecutor.initialize();
        return taskExecutor;
    }
}

