/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.spring.helper;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class BeanRegistryHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.dromara.mendmix.spring");

    public static String register(ApplicationContext context, String beanName, Class<?> beanClass, List<BeanValue> constructorArgValues, Map<String, BeanValue> propertyPairs) {
        DefaultListableBeanFactory registry = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        return BeanRegistryHelper.register((BeanDefinitionRegistry)registry, beanName, beanClass, constructorArgValues, propertyPairs);
    }

    public static String register(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, List<BeanValue> constructorArgValues, Map<String, BeanValue> propertyPairs) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass);
        if (constructorArgValues != null) {
            for (BeanValue arg : constructorArgValues) {
                if (arg.reference) {
                    beanDefinitionBuilder.addConstructorArgReference(arg.value.toString());
                    continue;
                }
                beanDefinitionBuilder.addConstructorArgValue(arg.value);
            }
        }
        if (propertyPairs != null) {
            propertyPairs.forEach((k, v) -> {
                if (v.reference) {
                    beanDefinitionBuilder.addPropertyReference(k, v.value.toString());
                } else {
                    beanDefinitionBuilder.addPropertyValue(k, v.value);
                }
            });
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
        logger.info("MENDMIX-TRACE-LOGGGING-->> register Bean[{}] Finished -> className:{}", (Object)beanName, (Object)beanClass.getName());
        return beanName;
    }

    public static class BeanValue {
        public Object value;
        public boolean reference;

        public BeanValue(Object value) {
            this.value = value;
        }

        public BeanValue(Object value, boolean reference) {
            this.value = value;
            this.reference = reference;
        }

        public String toString() {
            return "BeanValue [value=" + this.value + ", reference=" + this.reference + "]";
        }
    }
}

