/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.spring.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.dromara.mendmix.common.GlobalContext;
import org.dromara.mendmix.common.crypt.CustomEncryptor;
import org.dromara.mendmix.common.util.ResourceUtils;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnvironmentHelper {
    private static Environment environment;

    public static synchronized void init(ApplicationContext applicationContext) {
        if (environment != null) {
            return;
        }
        environment = applicationContext.getEnvironment();
        if (environment == null) {
            environment = (Environment)applicationContext.getBean(Environment.class);
        }
        if (environment != null) {
            List<String> resolvedKeys = EnvironmentHelper.mergeEnvironmentProperties();
            ResourceUtils.printAllConfigs(resolvedKeys);
            System.setProperty("client.nodeId", GlobalContext.getNodeName());
        }
    }

    public static String getProperty(String key) {
        return environment == null ? null : environment.getProperty(key);
    }

    public static boolean containsProperty(String key) {
        return environment == null ? false : environment.containsProperty(key);
    }

    private static List<String> mergeEnvironmentProperties() {
        String key;
        MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
        List names = propertySources.stream().map(o -> o.getName()).collect(Collectors.toList());
        for (int i = names.size() - 1; i >= 0; --i) {
            String name = (String)names.get(i);
            if (name.startsWith("servlet") || name.equals("systemEnvironment") || name.equals("systemProperties") || name.equals("random") || name.equals("cachedrandom") || name.contains("classpath") || name.contains("class path")) continue;
            PropertySource source = propertySources.get(name);
            int count = 0;
            if (source instanceof EnumerablePropertySource) {
                for (String propKey : ((EnumerablePropertySource)source).getPropertyNames()) {
                    Object value = source.getProperty(propKey);
                    if (value == null) continue;
                    ResourceUtils.add((String)propKey, (String)value.toString());
                    ++count;
                }
            }
            System.out.println(">>merge PropertySource:" + source.getName() + ",nums:" + count);
        }
        ArrayList<String> sensitiveKeys = new ArrayList<String>();
        Properties resolveProperties = new Properties();
        Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            key = entry.getKey().toString();
            String value = Objects.toString(entry.getValue(), null);
            if (value == null || !value.startsWith("{hidden}")) continue;
            value = value.substring(8);
            resolveProperties.setProperty(key, value);
            sensitiveKeys.add(key);
            iterator.remove();
        }
        for (Map.Entry<Object, Object> entry : ResourceUtils.getAllProperties().entrySet()) {
            String value;
            key = entry.getKey().toString();
            if (System.getProperties().containsKey(key)) {
                value = System.getProperty(key);
                ResourceUtils.add((String)key, (String)value);
                continue;
            }
            if (resolveProperties.containsKey(key) || !(value = entry.getValue().toString()).startsWith("{Cipher}")) continue;
            value = EnvironmentHelper.decryptConfigValue(value);
            resolveProperties.setProperty(key, value);
            sensitiveKeys.add(key);
        }
        if (!resolveProperties.isEmpty()) {
            OriginTrackedMapPropertySource propertySource = new OriginTrackedMapPropertySource("dynaResolveProperties", (Map)resolveProperties);
            propertySources.addFirst((PropertySource)propertySource);
            ResourceUtils.merge((Properties)resolveProperties);
        }
        return sensitiveKeys;
    }

    public static String decryptConfigValue(String value) {
        String plainText = value.replace("{Cipher}", "").trim();
        plainText = CustomEncryptor.useDefault().decrypt(plainText);
        return plainText;
    }
}

