/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mendmix.spring.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.mendmix.spring.InterceptorHanlder;

public abstract class MendmixSpringBaseInterceptor {
    private static List<InterceptorHanlder> handlers = new ArrayList<InterceptorHanlder>();

    public static void registerHandler(InterceptorHanlder hanlder) {
        handlers.add(hanlder);
    }

    public abstract void pointcut();

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Exception ex = null;
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Object[] args = pjp.getArgs();
        Object result = null;
        try {
            for (InterceptorHanlder hanlder : handlers) {
                hanlder.preHandler(method, args);
            }
            Object object = result = pjp.proceed();
            return object;
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            for (InterceptorHanlder hanlder : handlers) {
                hanlder.postHandler(result, ex);
            }
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.dromara.mendmix.mybatis.spring.MyBatisInterceptorHanlder");
            InterceptorHanlder hanlder = (InterceptorHanlder)clazz.newInstance();
            handlers.add(hanlder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

