/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.jfinal.client;

import com.jfinal.plugin.IPlugin;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.core.client.MqttClient;
import org.dromara.mica.mqtt.core.client.MqttClientCreator;
import org.dromara.mica.mqtt.jfinal.client.MqttClientKit;

public class MqttClientPlugin
implements IPlugin {
    private final MqttClientCreator clientCreator = new MqttClientCreator();
    private MqttClient mqttClient;

    public void config(Consumer<MqttClientCreator> consumer) {
        consumer.accept(this.clientCreator);
    }

    public boolean start() {
        if (this.mqttClient == null) {
            Integer timeout = this.clientCreator.getTimeout();
            if (timeout == null) {
                this.clientCreator.timeout(3);
            }
            this.mqttClient = this.clientCreator.connectSync();
        } else {
            this.mqttClient.reconnect();
        }
        MqttClientKit.init(this.mqttClient);
        return true;
    }

    public boolean stop() {
        if (this.mqttClient != null) {
            this.mqttClient.stop();
        }
        return true;
    }
}

