/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.jfinal.client;

import java.util.List;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.builder.MqttPublishBuilder;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.core.client.IMqttClientMessageListener;
import org.dromara.mica.mqtt.core.client.MqttClient;
import org.dromara.mica.mqtt.core.client.MqttClientCreator;
import org.dromara.mica.mqtt.core.client.MqttClientSubscription;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;

public class MqttClientKit {
    private static MqttClient client;

    static void init(MqttClient client) {
        MqttClientKit.client = client;
    }

    public static MqttClient subQos0(String topicFilter, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS0, listener, null);
    }

    public static MqttClient subQos0(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS0, listener, properties);
    }

    public static MqttClient subQos1(String topicFilter, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS1, listener, null);
    }

    public static MqttClient subQos1(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS1, listener, properties);
    }

    public static MqttClient subQos2(String topicFilter, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS2, listener, null);
    }

    public static MqttClient subQos2(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, MqttQoS.QOS2, listener, properties);
    }

    public static MqttClient subscribe(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public static MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public static MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return client.subscribe(topicFilter, mqttQoS, listener, properties);
    }

    public static MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return client.subscribe(topicFilters, mqttQoS, listener, null);
    }

    public static MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return client.subscribe(topicFilters, mqttQoS, listener, properties);
    }

    public static MqttClient subscribe(List<MqttClientSubscription> subscriptionList) {
        return client.subscribe(subscriptionList, null);
    }

    public static MqttClient subscribe(List<MqttClientSubscription> subscriptionList, MqttProperties properties) {
        return client.subscribe(subscriptionList, properties);
    }

    public static MqttClient unSubscribe(String ... topicFilters) {
        return client.unSubscribe(topicFilters);
    }

    public static MqttClient unSubscribe(List<String> topicFilters) {
        return client.unSubscribe(topicFilters);
    }

    public static boolean publish(String topic, Object payload) {
        return client.publish(topic, payload);
    }

    public static boolean publish(String topic, Object payload, MqttQoS qos) {
        return client.publish(topic, payload, qos);
    }

    public static boolean publish(String topic, Object payload, boolean retain) {
        return client.publish(topic, payload, retain);
    }

    public static boolean publish(String topic, Object payload, MqttQoS qos, boolean retain) {
        return client.publish(topic, payload, qos, retain);
    }

    public static boolean publish(String topic, Object payload, MqttQoS qos, Consumer<MqttPublishBuilder> builder) {
        return client.publish(topic, payload, qos, builder);
    }

    public static void reconnect() {
        client.reconnect();
    }

    public static boolean disconnect() {
        return client.disconnect();
    }

    public static TioClient getTioClient() {
        return client.getTioClient();
    }

    public static MqttClientCreator getClientCreator() {
        return client.getClientCreator();
    }

    public static TioClientConfig getClientTioConfig() {
        return client.getClientTioConfig();
    }

    public static ClientChannelContext getContext() {
        return client.getContext();
    }

    public static boolean isConnected() {
        return client.isConnected();
    }

    public static boolean isDisconnected() {
        return client.isDisconnected();
    }
}

