/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.io.Serializable;
import java.util.Objects;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.MqttTopicSubscription;
import org.dromara.mica.mqtt.core.client.IMqttClientMessageListener;
import org.dromara.mica.mqtt.core.common.TopicFilterType;

public final class MqttClientSubscription
implements Serializable {
    private final String topicFilter;
    private final MqttQoS mqttQoS;
    private final TopicFilterType type;
    private final transient IMqttClientMessageListener listener;

    public MqttClientSubscription(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        this.mqttQoS = Objects.requireNonNull(mqttQoS, "MQTT subscribe mqttQoS is null.");
        this.topicFilter = Objects.requireNonNull(topicFilter, "MQTT subscribe topicFilter is null.");
        this.type = TopicFilterType.getType((String)topicFilter);
        this.listener = Objects.requireNonNull(listener, "MQTT subscribe listener is null.");
    }

    public MqttQoS getMqttQoS() {
        return this.mqttQoS;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public IMqttClientMessageListener getListener() {
        return this.listener;
    }

    public boolean matches(String topic) {
        return this.type.match(this.topicFilter, topic);
    }

    public MqttTopicSubscription toTopicSubscription() {
        return new MqttTopicSubscription(this.topicFilter, this.mqttQoS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttClientSubscription that = (MqttClientSubscription)o;
        return Objects.equals(this.topicFilter, that.topicFilter) && this.mqttQoS == that.mqttQoS && Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hash(this.topicFilter, this.mqttQoS, this.listener);
    }

    public String toString() {
        return "MqttClientSubscription{topicFilter='" + this.topicFilter + '\'' + ", mqttQoS=" + this.mqttQoS + '}';
    }
}

