/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.nio.ByteBuffer;
import org.dromara.mica.mqtt.codec.DecoderResult;
import org.dromara.mica.mqtt.codec.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.MqttDecoder;
import org.dromara.mica.mqtt.codec.MqttEncoder;
import org.dromara.mica.mqtt.codec.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttPubAckMessage;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttSubAckMessage;
import org.dromara.mica.mqtt.codec.MqttUnsubAckMessage;
import org.dromara.mica.mqtt.core.client.IMqttClientProcessor;
import org.dromara.mica.mqtt.core.client.MqttClientCreator;
import org.tio.client.intf.TioClientHandler;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.utils.buffer.ByteBufferAllocator;

public class MqttClientAioHandler
implements TioClientHandler {
    private final MqttDecoder mqttDecoder;
    private final MqttEncoder mqttEncoder;
    private final ByteBufferAllocator allocator;
    private final IMqttClientProcessor processor;

    public MqttClientAioHandler(MqttClientCreator mqttClientCreator, IMqttClientProcessor processor) {
        this.mqttDecoder = new MqttDecoder(mqttClientCreator.getMaxBytesInMessage(), mqttClientCreator.getMaxClientIdLength());
        this.mqttEncoder = MqttEncoder.INSTANCE;
        this.allocator = mqttClientCreator.getBufferAllocator();
        this.processor = processor;
    }

    public Packet heartbeatPacket(ChannelContext channelContext) {
        return MqttMessage.PINGREQ;
    }

    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        return this.mqttDecoder.doDecode(context, buffer, readableLength);
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        return this.mqttEncoder.doEncode(channelContext, (MqttMessage)packet, this.allocator);
    }

    public void handler(Packet packet, ChannelContext context) {
        MqttMessage message = (MqttMessage)packet;
        DecoderResult decoderResult = message.decoderResult();
        if (decoderResult.isFailure()) {
            this.processor.processDecodeFailure(context, message, decoderResult.getCause());
            return;
        }
        MqttFixedHeader fixedHeader = message.fixedHeader();
        MqttMessageType messageType = fixedHeader.messageType();
        switch (messageType) {
            case CONNACK: {
                this.processor.processConAck(context, (MqttConnAckMessage)message);
                break;
            }
            case SUBACK: {
                this.processor.processSubAck(context, (MqttSubAckMessage)message);
                break;
            }
            case PUBLISH: {
                this.processor.processPublish(context, (MqttPublishMessage)message);
                break;
            }
            case UNSUBACK: {
                this.processor.processUnSubAck((MqttUnsubAckMessage)message);
                break;
            }
            case PUBACK: {
                this.processor.processPubAck((MqttPubAckMessage)message);
                break;
            }
            case PUBREC: {
                this.processor.processPubRec(context, message);
                break;
            }
            case PUBREL: {
                this.processor.processPubRel(context, message);
                break;
            }
            case PUBCOMP: {
                this.processor.processPubComp(message);
                break;
            }
        }
    }
}

