/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.mica.mqtt.codec.MqttConnectReasonCode;
import org.dromara.mica.mqtt.codec.MqttProperties;
import org.dromara.mica.mqtt.codec.MqttTopicSubscription;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.core.client.DefaultMqttClientMessageIdGenerator;
import org.dromara.mica.mqtt.core.client.DefaultMqttClientProcessor;
import org.dromara.mica.mqtt.core.client.DefaultMqttClientSession;
import org.dromara.mica.mqtt.core.client.IMqttClientConnectListener;
import org.dromara.mica.mqtt.core.client.IMqttClientGlobalMessageListener;
import org.dromara.mica.mqtt.core.client.IMqttClientMessageIdGenerator;
import org.dromara.mica.mqtt.core.client.IMqttClientSession;
import org.dromara.mica.mqtt.core.client.MqttClient;
import org.dromara.mica.mqtt.core.client.MqttClientAioHandler;
import org.dromara.mica.mqtt.core.client.MqttClientAioListener;
import org.dromara.mica.mqtt.core.client.MqttClientConnectTestProcessor;
import org.dromara.mica.mqtt.core.client.MqttClientId;
import org.dromara.mica.mqtt.core.client.MqttWillMessage;
import org.dromara.mica.mqtt.core.serializer.MqttJsonSerializer;
import org.dromara.mica.mqtt.core.serializer.MqttSerializer;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.client.intf.TioClientHandler;
import org.tio.client.intf.TioClientListener;
import org.tio.client.task.HeartbeatTimeoutStrategy;
import org.tio.core.Node;
import org.tio.core.TioConfig;
import org.tio.core.intf.TioUuid;
import org.tio.core.ssl.SslConfig;
import org.tio.core.task.HeartbeatMode;
import org.tio.utils.buffer.ByteBufferAllocator;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.TimerTaskService;

public final class MqttClientCreator {
    public static final int DEFAULT_KEEP_ALIVE_SECS = 60;
    private String name = "Mica-Mqtt-Client";
    private String ip = "127.0.0.1";
    private int port = 1883;
    private Integer timeout;
    private int readBufferSize = 8192;
    private int maxBytesInMessage = 0xA00000;
    private int maxClientIdLength = 64;
    private int keepAliveSecs = 60;
    private HeartbeatMode heartbeatMode = HeartbeatMode.LAST_REQ;
    private HeartbeatTimeoutStrategy heartbeatTimeoutStrategy = HeartbeatTimeoutStrategy.PING;
    private SslConfig sslConfig;
    private boolean reconnect = true;
    private long reInterval = 5000L;
    private int retryCount = 0;
    private int reSubscribeBatchSize = 20;
    private String clientId;
    private MqttVersion version = MqttVersion.MQTT_3_1_1;
    private String username = null;
    private String password = null;
    private boolean cleanSession = true;
    private Integer sessionExpiryIntervalSecs;
    private MqttWillMessage willMessage;
    private MqttProperties properties;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private IMqttClientConnectListener connectListener;
    private Set<MqttTopicSubscription> globalSubscribe;
    private IMqttClientGlobalMessageListener globalMessageListener;
    private IMqttClientSession clientSession;
    private IMqttClientMessageIdGenerator messageIdGenerator;
    private boolean statEnable = false;
    private boolean debug = false;
    private SynThreadPoolExecutor tioExecutor;
    private ExecutorService groupExecutor;
    private ExecutorService mqttExecutor;
    private TimerTaskService taskService;
    private Consumer<TioConfig> tioConfigCustomize;
    private MqttSerializer mqttSerializer;

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getKeepAliveSecs() {
        return this.keepAliveSecs;
    }

    public HeartbeatMode getHeartbeatMode() {
        return this.heartbeatMode;
    }

    public HeartbeatTimeoutStrategy getHeartbeatTimeoutStrategy() {
        return this.heartbeatTimeoutStrategy;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getReInterval() {
        return this.reInterval;
    }

    public int getReSubscribeBatchSize() {
        return this.reSubscribeBatchSize;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttVersion getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public Integer getSessionExpiryIntervalSecs() {
        return this.sessionExpiryIntervalSecs;
    }

    public MqttWillMessage getWillMessage() {
        return this.willMessage;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public IMqttClientConnectListener getConnectListener() {
        return this.connectListener;
    }

    public Set<MqttTopicSubscription> getGlobalSubscribe() {
        return this.globalSubscribe;
    }

    public IMqttClientGlobalMessageListener getGlobalMessageListener() {
        return this.globalMessageListener;
    }

    public IMqttClientSession getClientSession() {
        return this.clientSession;
    }

    public IMqttClientMessageIdGenerator getMessageIdGenerator() {
        return this.messageIdGenerator;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public SynThreadPoolExecutor getTioExecutor() {
        return this.tioExecutor;
    }

    public ExecutorService getGroupExecutor() {
        return this.groupExecutor;
    }

    public ExecutorService getMqttExecutor() {
        return this.mqttExecutor;
    }

    public TimerTaskService getTaskService() {
        return this.taskService;
    }

    public MqttSerializer getMqttSerializer() {
        return this.mqttSerializer;
    }

    public MqttClientCreator name(String name) {
        this.name = name;
        return this;
    }

    public MqttClientCreator ip(String ip) {
        this.ip = ip;
        return this;
    }

    public MqttClientCreator port(int port) {
        this.port = port;
        return this;
    }

    public MqttClientCreator timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public MqttClientCreator readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public MqttClientCreator maxBytesInMessage(int maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    public MqttClientCreator maxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public MqttClientCreator keepAliveSecs(int keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
        return this;
    }

    public MqttClientCreator heartbeatMode(HeartbeatMode heartbeatMode) {
        this.heartbeatMode = heartbeatMode;
        return this;
    }

    public MqttClientCreator heartbeatTimeoutStrategy(HeartbeatTimeoutStrategy heartbeatTimeoutStrategy) {
        this.heartbeatTimeoutStrategy = heartbeatTimeoutStrategy;
        return this;
    }

    public MqttClientCreator useSsl() {
        return this.sslConfig(SslConfig.forClient());
    }

    public MqttClientCreator useSsl(String trustStoreFile, String trustPassword) {
        return this.sslConfig(SslConfig.forClient((String)trustStoreFile, (String)trustPassword));
    }

    public MqttClientCreator useSsl(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword) {
        return this.sslConfig(SslConfig.forClient((String)keyStoreFile, (String)keyPasswd, (String)trustStoreFile, (String)trustPassword));
    }

    public MqttClientCreator useSsl(InputStream trustStoreInputStream, String trustPassword) {
        return this.sslConfig(SslConfig.forClient((InputStream)trustStoreInputStream, (String)trustPassword));
    }

    public MqttClientCreator useSsl(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword) {
        return this.sslConfig(SslConfig.forClient((InputStream)keyStoreInputStream, (String)keyPasswd, (InputStream)trustStoreInputStream, (String)trustPassword));
    }

    public MqttClientCreator sslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public MqttClientCreator reconnect(boolean reconnect) {
        this.reconnect = reconnect;
        return this;
    }

    public MqttClientCreator retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public MqttClientCreator reInterval(long reInterval) {
        this.reInterval = reInterval;
        return this;
    }

    public MqttClientCreator reSubscribeBatchSize(int reSubscribeBatchSize) {
        this.reSubscribeBatchSize = reSubscribeBatchSize;
        return this;
    }

    public MqttClientCreator clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MqttClientCreator version(MqttVersion version) {
        this.version = version;
        return this;
    }

    public MqttClientCreator username(String username) {
        this.username = username;
        return this;
    }

    public MqttClientCreator password(String password) {
        this.password = password;
        return this;
    }

    public MqttClientCreator cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public MqttClientCreator sessionExpiryIntervalSecs(Integer sessionExpiryIntervalSecs) {
        this.sessionExpiryIntervalSecs = sessionExpiryIntervalSecs;
        return this;
    }

    public MqttClientCreator willMessage(MqttWillMessage willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public MqttClientCreator willMessage(Consumer<MqttWillMessage.Builder> consumer) {
        MqttWillMessage.Builder builder = MqttWillMessage.builder();
        consumer.accept(builder);
        return this.willMessage(builder.build());
    }

    public MqttClientCreator properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttClientCreator bufferAllocator(ByteBufferAllocator allocator) {
        this.bufferAllocator = allocator;
        return this;
    }

    public MqttClientCreator connectListener(IMqttClientConnectListener connectListener) {
        this.connectListener = connectListener;
        return this;
    }

    public MqttClientCreator globalSubscribe(String ... topics) {
        Objects.requireNonNull(topics, "globalSubscribe topics is null.");
        List<MqttTopicSubscription> subscriptionList = Arrays.stream(topics).map(MqttTopicSubscription::new).collect(Collectors.toList());
        return this.globalSubscribe(subscriptionList);
    }

    public MqttClientCreator globalSubscribe(MqttTopicSubscription ... topics) {
        Objects.requireNonNull(topics, "globalSubscribe topics is null.");
        return this.globalSubscribe(Arrays.asList(topics));
    }

    public MqttClientCreator globalSubscribe(List<MqttTopicSubscription> topicList) {
        Objects.requireNonNull(topicList, "globalSubscribe topicList is null.");
        if (this.globalSubscribe == null) {
            this.globalSubscribe = new HashSet<MqttTopicSubscription>(topicList);
        } else {
            this.globalSubscribe.addAll(topicList);
        }
        return this;
    }

    public MqttClientCreator globalMessageListener(IMqttClientGlobalMessageListener globalMessageListener) {
        this.globalMessageListener = globalMessageListener;
        return this;
    }

    public MqttClientCreator clientSession(IMqttClientSession clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    public MqttClientCreator messageIdGenerator(IMqttClientMessageIdGenerator messageIdGenerator) {
        this.messageIdGenerator = messageIdGenerator;
        return this;
    }

    public MqttClientCreator statEnable() {
        return this.statEnable(true);
    }

    public MqttClientCreator statEnable(boolean enable) {
        this.statEnable = enable;
        return this;
    }

    public MqttClientCreator debug() {
        this.debug = true;
        return this;
    }

    public MqttClientCreator tioExecutor(SynThreadPoolExecutor tioExecutor) {
        this.tioExecutor = tioExecutor;
        return this;
    }

    public MqttClientCreator groupExecutor(ExecutorService groupExecutor) {
        this.groupExecutor = groupExecutor;
        return this;
    }

    public MqttClientCreator mqttExecutor(ExecutorService mqttExecutor) {
        this.mqttExecutor = mqttExecutor;
        return this;
    }

    public MqttClientCreator bizThreadPoolSize(int poolSize) {
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be greater than zero.");
        }
        return this.mqttExecutor(ThreadUtils.getBizExecutor((int)poolSize));
    }

    public MqttClientCreator taskService(TimerTaskService taskService) {
        this.taskService = taskService;
        return this;
    }

    public MqttClientCreator tioConfigCustomize(Consumer<TioConfig> tioConfigCustomize) {
        this.tioConfigCustomize = tioConfigCustomize;
        return this;
    }

    public MqttClientCreator mqttJsonSerializer(MqttSerializer mqttSerializer) {
        this.mqttSerializer = mqttSerializer;
        return this;
    }

    private MqttClient build() {
        if (StrUtil.isBlank((CharSequence)this.clientId)) {
            this.clientId("MICA-MQTT-" + Long.toString(System.nanoTime(), 36));
        }
        if (this.clientSession == null) {
            this.clientSession = new DefaultMqttClientSession();
        }
        if (this.messageIdGenerator == null) {
            this.messageIdGenerator = new DefaultMqttClientMessageIdGenerator();
        }
        if (this.tioExecutor == null) {
            this.tioExecutor = ThreadUtils.getTioExecutor((int)3);
        }
        if (this.groupExecutor == null) {
            this.groupExecutor = ThreadUtils.getGroupExecutor((int)2);
        }
        if (this.mqttExecutor == null) {
            this.mqttExecutor = ThreadUtils.getBizExecutor((int)2);
        }
        if (this.taskService == null) {
            this.taskService = new DefaultTimerTaskService();
        }
        if (this.heartbeatMode == null) {
            this.heartbeatMode = HeartbeatMode.LAST_REQ;
        }
        if (this.mqttSerializer == null) {
            this.mqttSerializer = new MqttJsonSerializer();
        }
        DefaultMqttClientProcessor processor = new DefaultMqttClientProcessor(this);
        MqttClientAioHandler clientAioHandler = new MqttClientAioHandler(this, processor);
        MqttClientAioListener clientAioListener = new MqttClientAioListener(this);
        ReconnConf reconnConf = null;
        if (this.reconnect) {
            reconnConf = new ReconnConf(this.reInterval, this.retryCount);
        }
        TioClientConfig clientConfig = new TioClientConfig((TioClientHandler)clientAioHandler, (TioClientListener)clientAioListener, reconnConf, this.tioExecutor, this.groupExecutor);
        clientConfig.setName(this.name);
        clientConfig.setHeartbeatTimeout(TimeUnit.SECONDS.toMillis(this.keepAliveSecs));
        clientConfig.setHeartbeatMode(this.heartbeatMode);
        clientConfig.setHeartbeatTimeoutStrategy(this.heartbeatTimeoutStrategy);
        if (this.readBufferSize > 0) {
            clientConfig.setReadBufferSize(this.readBufferSize);
        }
        clientConfig.setSslConfig(this.sslConfig);
        clientConfig.statOn = this.statEnable;
        if (this.debug) {
            clientConfig.debug = true;
        }
        if (this.tioConfigCustomize != null) {
            this.tioConfigCustomize.accept((TioConfig)clientConfig);
        }
        clientConfig.setTioUuid((TioUuid)new MqttClientId(this));
        try {
            TioClient tioClient = new TioClient(clientConfig);
            return new MqttClient(tioClient, this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Mica mqtt client start fail.", e);
        }
    }

    public MqttClient connect() {
        return this.build().start(false);
    }

    public MqttClient connectSync() {
        return this.build().start(true);
    }

    public MqttConnectReasonCode connectTest() {
        return this.connectTest(3L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttConnectReasonCode connectTest(long timeout, TimeUnit timeUnit) {
        TioClient tioClient;
        if (StrUtil.isBlank((CharSequence)this.clientId)) {
            this.clientId("MICA-MQTT-" + Long.toString(System.nanoTime(), 36));
        }
        CompletableFuture<MqttConnectReasonCode> future = new CompletableFuture<MqttConnectReasonCode>();
        MqttClientConnectTestProcessor processor = new MqttClientConnectTestProcessor(future);
        MqttClientAioHandler clientAioHandler = new MqttClientAioHandler(this, processor);
        MqttClientAioListener clientAioListener = new MqttClientAioListener(this);
        TioClientConfig tioConfig = new TioClientConfig((TioClientHandler)clientAioHandler, (TioClientListener)clientAioListener);
        tioConfig.setName(this.name);
        tioConfig.setHeartbeatTimeout(0L);
        try {
            tioClient = new TioClient(tioConfig);
            tioClient.asyncConnect(new Node(this.getIp(), this.getPort()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Mica mqtt client start fail.", e);
        }
        try {
            MqttConnectReasonCode e = future.get(timeout, timeUnit);
            return e;
        }
        catch (Exception e) {
            MqttConnectReasonCode mqttConnectReasonCode = MqttConnectReasonCode.CONNECTION_REFUSED_SERVER_UNAVAILABLE;
            return mqttConnectReasonCode;
        }
        finally {
            tioClient.stop();
        }
    }
}

