/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.core.client.IMqttClientMessageListener;
import org.dromara.mica.mqtt.core.client.IMqttClientSession;
import org.dromara.mica.mqtt.core.client.MqttClientSubscription;
import org.dromara.mica.mqtt.core.client.MqttPendingSubscription;
import org.dromara.mica.mqtt.core.client.MqttPendingUnSubscription;
import org.dromara.mica.mqtt.core.common.MqttPendingPublish;
import org.dromara.mica.mqtt.core.common.MqttPendingQos2Publish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.collection.IntObjectHashMap;
import org.tio.utils.collection.IntObjectMap;
import org.tio.utils.collection.MultiValueMap;

public class DefaultMqttClientSession
implements IMqttClientSession {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMqttClientSession.class);
    private final AtomicInteger packetIdGen = new AtomicInteger(1);
    private final MultiValueMap<String, MqttClientSubscription> subscriptions = new MultiValueMap(new ConcurrentHashMap());
    private final IntObjectMap<MqttPendingSubscription> pendingSubscriptions = new IntObjectHashMap();
    private final IntObjectMap<MqttPendingUnSubscription> pendingUnSubscriptions = new IntObjectHashMap();
    private final IntObjectMap<MqttPendingPublish> pendingPublishData = new IntObjectHashMap();
    private final IntObjectMap<MqttPendingQos2Publish> pendingQos2PublishData = new IntObjectHashMap();

    @Override
    public int getPacketId() {
        return this.packetIdGen.getAndUpdate(current -> current % 65535 == 0 ? 1 : current + 1);
    }

    @Override
    public void addPaddingSubscribe(int messageId, MqttPendingSubscription pendingSubscription) {
        this.pendingSubscriptions.put(messageId, (Object)pendingSubscription);
    }

    @Override
    public MqttPendingSubscription getPaddingSubscribe(int messageId) {
        return (MqttPendingSubscription)this.pendingSubscriptions.get(messageId);
    }

    @Override
    public void removePaddingSubscribes(List<String> topicFilters) {
        HashSet needToRemove = new HashSet();
        this.pendingSubscriptions.forEach((messageId, pendingSubscription) -> {
            List<MqttClientSubscription> subscriptionList = pendingSubscription.getSubscriptionList();
            if (subscriptionList != null) {
                subscriptionList.removeIf(subscription -> topicFilters.contains(subscription.getTopicFilter()));
            }
            if (subscriptionList == null || subscriptionList.isEmpty()) {
                pendingSubscription.onSubAckReceived();
                needToRemove.add(messageId);
            }
        });
        needToRemove.forEach(arg_0 -> this.pendingSubscriptions.remove(arg_0));
    }

    @Override
    public MqttPendingSubscription removePaddingSubscribe(int messageId) {
        return (MqttPendingSubscription)this.pendingSubscriptions.remove(messageId);
    }

    @Override
    public void addSubscription(MqttClientSubscription subscription) {
        this.subscriptions.add((Object)subscription.getTopicFilter(), (Object)subscription);
    }

    @Override
    public boolean isSubscribed(MqttClientSubscription clientSubscription) {
        String topicFilter = clientSubscription.getTopicFilter();
        Set subscriptionSet = this.subscriptions.get((Object)topicFilter);
        if (subscriptionSet == null || subscriptionSet.isEmpty()) {
            return false;
        }
        MqttQoS mqttQoS = clientSubscription.getMqttQoS();
        IMqttClientMessageListener listener = clientSubscription.getListener();
        for (MqttClientSubscription subscription : subscriptionSet) {
            if (clientSubscription.equals(subscription)) {
                logger.error("MQTT Topic:{} mqttQoS:{} listener:{} duplicate subscription.", new Object[]{topicFilter, mqttQoS, listener});
                return true;
            }
            MqttQoS subQos = subscription.getMqttQoS();
            IMqttClientMessageListener subListener = subscription.getListener();
            if (subQos.value() < mqttQoS.value()) continue;
            if (subListener != listener) {
                this.subscriptions.add((Object)topicFilter, (Object)clientSubscription);
                logger.warn("MQTT Topic:{} mqttQoS:{} listener:{} has a higher level qos, added directly.", new Object[]{topicFilter, mqttQoS, listener});
            } else {
                logger.error("MQTT Topic:{} mqttQoS:{} listener:{} has a higher level qos, duplicate subscription.", new Object[]{topicFilter, mqttQoS, listener});
            }
            return true;
        }
        return false;
    }

    @Override
    public List<MqttClientSubscription> getSubscriptions() {
        ArrayList subscriptionList = new ArrayList();
        for (Set mqttSubscriptions : this.subscriptions.values()) {
            subscriptionList.addAll(mqttSubscriptions);
        }
        return Collections.unmodifiableList(subscriptionList);
    }

    @Override
    public List<MqttClientSubscription> getMatchedSubscription(String topicName) {
        return this.subscriptions.values().stream().flatMap(Collection::stream).filter(subscription -> subscription.matches(topicName)).collect(Collectors.toList());
    }

    @Override
    public void removeSubscriptions(List<String> topicFilters) {
        topicFilters.forEach(arg_0 -> this.subscriptions.remove(arg_0));
    }

    @Override
    public void addPaddingUnSubscribe(int messageId, MqttPendingUnSubscription pendingUnSubscription) {
        this.pendingUnSubscriptions.put(messageId, (Object)pendingUnSubscription);
    }

    @Override
    public MqttPendingUnSubscription getPaddingUnSubscribe(int messageId) {
        return (MqttPendingUnSubscription)this.pendingUnSubscriptions.get(messageId);
    }

    @Override
    public MqttPendingUnSubscription removePaddingUnSubscribe(int messageId) {
        return (MqttPendingUnSubscription)this.pendingUnSubscriptions.remove(messageId);
    }

    @Override
    public void addPendingPublish(int messageId, MqttPendingPublish pendingPublish) {
        this.pendingPublishData.put(messageId, (Object)pendingPublish);
    }

    @Override
    public MqttPendingPublish getPendingPublish(int messageId) {
        return (MqttPendingPublish)this.pendingPublishData.get(messageId);
    }

    @Override
    public MqttPendingPublish removePendingPublish(int messageId) {
        return (MqttPendingPublish)this.pendingPublishData.remove(messageId);
    }

    @Override
    public void addPendingQos2Publish(int messageId, MqttPendingQos2Publish pendingQos2Publish) {
        this.pendingQos2PublishData.put(messageId, (Object)pendingQos2Publish);
    }

    @Override
    public MqttPendingQos2Publish getPendingQos2Publish(int messageId) {
        return (MqttPendingQos2Publish)this.pendingQos2PublishData.get(messageId);
    }

    @Override
    public MqttPendingQos2Publish removePendingQos2Publish(int messageId) {
        return (MqttPendingQos2Publish)this.pendingQos2PublishData.remove(messageId);
    }

    @Override
    public void clean() {
        this.subscriptions.clear();
        this.pendingSubscriptions.clear();
        this.pendingUnSubscriptions.clear();
        this.pendingPublishData.clear();
        this.pendingQos2PublishData.clear();
    }
}

