/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.message.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.message.builder.MqttConnectBuilder;
import org.dromara.mica.mqtt.codec.message.builder.MqttMessageBuilders;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperty;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.core.client.IMqttClientConnectListener;
import org.dromara.mica.mqtt.core.client.MqttClientCreator;
import org.dromara.mica.mqtt.core.client.MqttWillMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.DefaultTioClientListener;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.hutool.StrUtil;

public class MqttClientAioListener
extends DefaultTioClientListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttClientAioListener.class);
    private final MqttClientCreator clientCreator;
    private final IMqttClientConnectListener connectListener;
    private final ExecutorService executor;

    public MqttClientAioListener(MqttClientCreator clientCreator) {
        this.clientCreator = clientCreator;
        this.connectListener = clientCreator.getConnectListener();
        this.executor = clientCreator.getMqttExecutor();
    }

    public void onAfterConnected(ChannelContext context, boolean isConnected, boolean isReconnect) {
        if (isConnected) {
            boolean result = Tio.bSend((ChannelContext)context, (Packet)MqttClientAioListener.getConnectMessage(this.clientCreator));
            logger.info("MqttClient reconnect send connect result:{}", (Object)result);
            if (!result) {
                Tio.close((ChannelContext)context, (String)"MqttClient reconnect send fail.");
            }
        }
    }

    public void onBeforeClose(ChannelContext context, Throwable throwable, String remark, boolean isRemove) {
        context.setAccepted(false);
        if (this.connectListener == null) {
            return;
        }
        this.executor.submit(() -> {
            try {
                this.connectListener.onDisconnect(context, throwable, remark, isRemove);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        });
    }

    private static MqttConnectMessage getConnectMessage(MqttClientCreator mqttClientCreator) {
        MqttWillMessage willMessage = mqttClientCreator.getWillMessage();
        MqttVersion version = mqttClientCreator.getVersion();
        int keepAliveSecs = mqttClientCreator.getKeepAliveSecs();
        MqttConnectBuilder builder = MqttMessageBuilders.connect().clientId(mqttClientCreator.getClientId()).username(mqttClientCreator.getUsername()).cleanStart(mqttClientCreator.isCleanStart()).protocolVersion(version).keepAlive(keepAliveSecs > 0 ? keepAliveSecs : 60).willFlag(willMessage != null);
        String password = mqttClientCreator.getPassword();
        if (StrUtil.isNotBlank((CharSequence)password)) {
            builder.password(password.getBytes(StandardCharsets.UTF_8));
        }
        if (willMessage != null) {
            builder.willTopic(willMessage.getTopic()).willMessage(willMessage.getMessage()).willRetain(willMessage.isRetain()).willQoS(willMessage.getQos()).willProperties(willMessage.getWillProperties());
        }
        if (MqttVersion.MQTT_5 == version) {
            MqttProperties properties = mqttClientCreator.getProperties();
            Integer sessionExpiryInterval = mqttClientCreator.getSessionExpiryIntervalSecs();
            if (sessionExpiryInterval != null && sessionExpiryInterval > 0) {
                if (properties == null) {
                    properties = new MqttProperties();
                }
                properties.add((MqttProperty)new IntegerProperty(MqttPropertyType.SESSION_EXPIRY_INTERVAL, sessionExpiryInterval));
            }
            if (properties != null) {
                builder.properties(properties);
            }
        }
        return builder.build();
    }
}

