/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.util.List;
import java.util.Objects;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.MqttUnSubscribeMessage;
import org.dromara.mica.mqtt.core.common.RetryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.timer.TimerTaskService;

final class MqttPendingUnSubscription {
    private static final Logger logger = LoggerFactory.getLogger(MqttPendingUnSubscription.class);
    private final List<String> topics;
    private final RetryProcessor<MqttUnSubscribeMessage> retryProcessor = new RetryProcessor();

    MqttPendingUnSubscription(List<String> topics, MqttUnSubscribeMessage unSubscribeMessage) {
        this.topics = topics;
        this.retryProcessor.setOriginalMessage((MqttMessage)unSubscribeMessage);
    }

    List<String> getTopics() {
        return this.topics;
    }

    void startRetransmissionTimer(TimerTaskService taskService, ChannelContext context) {
        this.retryProcessor.setHandle((fixedHeader, originalMessage) -> {
            MqttUnSubscribeMessage message = new MqttUnSubscribeMessage(fixedHeader, originalMessage.variableHeader(), originalMessage.payload());
            boolean result = Tio.send((ChannelContext)context, (Packet)message);
            logger.info("retry send Unsubscribe topics:{} result:{}", this.topics, (Object)result);
        });
        this.retryProcessor.start(taskService);
    }

    void onUnSubAckReceived() {
        this.retryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingUnSubscription that = (MqttPendingUnSubscription)o;
        return Objects.equals(this.topics, that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.topics);
    }
}

