/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.core.annotation.MqttClientPublish;
import org.dromara.mica.mqtt.core.annotation.MqttPayload;
import org.dromara.mica.mqtt.core.annotation.MqttRetain;
import org.dromara.mica.mqtt.core.client.IMqttClient;
import org.dromara.mica.mqtt.core.client.MqttClient;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.tio.utils.hutool.CollUtil;

public class MqttInvocationHandler<T extends IMqttClient>
implements InvocationHandler {
    private final T mqttClient;
    private final ConcurrentMap<Method, MethodMetadata> methodCache;

    public MqttInvocationHandler(T mqttClient) {
        this.mqttClient = mqttClient;
        this.methodCache = new ConcurrentHashMap<Method, MethodMetadata>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        MethodMetadata metadata = this.resolveMethod(method);
        Object payload = metadata.getPayloadIndex() >= 0 ? args[metadata.getPayloadIndex()] : null;
        boolean retain = metadata.getRetainIndex() >= 0 && Boolean.TRUE.equals(args[metadata.getRetainIndex()]);
        MqttProperties properties = metadata.getPropertiesIndex() >= 0 ? (MqttProperties)args[metadata.getPropertiesIndex()] : null;
        Consumer builder = metadata.getBuilderIndex() >= 0 ? (Consumer)args[metadata.getBuilderIndex()] : null;
        String topic = TopicUtil.resolveTopic((String)metadata.getMqttPublish().value(), (Object)payload);
        MqttQoS qos = metadata.getMqttPublish().qos();
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("Resolved topic is null or empty");
        }
        MqttClient client = this.mqttClient.getMqttClient();
        if (builder == null) {
            return client.publish(topic, payload, qos, retain, properties);
        }
        return client.publish(topic, payload, qos, builder);
    }

    private MethodMetadata resolveMethod(Method method) {
        return (MethodMetadata)CollUtil.computeIfAbsent(this.methodCache, (Object)method, m -> {
            int i;
            MqttClientPublish mqttPublish = m.getAnnotation(MqttClientPublish.class);
            if (mqttPublish == null) {
                throw new UnsupportedOperationException("Method not annotated with @MqttClientPublish");
            }
            Annotation[][] paramAnnotations = m.getParameterAnnotations();
            Class<?>[] paramTypes = m.getParameterTypes();
            int payloadIndex = -1;
            int retainIndex = -1;
            int propertiesIndex = -1;
            int builderIndex = -1;
            for (i = 0; i < paramAnnotations.length; ++i) {
                for (Annotation annotation : paramAnnotations[i]) {
                    if (annotation instanceof MqttPayload) {
                        payloadIndex = i;
                        continue;
                    }
                    if (!(annotation instanceof MqttRetain)) continue;
                    retainIndex = i;
                }
            }
            for (i = 0; i < paramTypes.length; ++i) {
                if (propertiesIndex == -1 && MqttProperties.class.isAssignableFrom(paramTypes[i])) {
                    propertiesIndex = i;
                    continue;
                }
                if (builderIndex != -1 || !Consumer.class.isAssignableFrom(paramTypes[i])) continue;
                builderIndex = i;
            }
            return new MethodMetadata(mqttPublish, payloadIndex, retainIndex, propertiesIndex, builderIndex);
        });
    }

    private static class MethodMetadata {
        private final MqttClientPublish mqttPublish;
        private final int payloadIndex;
        private final int retainIndex;
        private final int propertiesIndex;
        private final int builderIndex;

        MethodMetadata(MqttClientPublish mqttPublish, int payloadIndex, int retainIndex, int propertiesIndex, int builderIndex) {
            this.mqttPublish = mqttPublish;
            this.payloadIndex = payloadIndex;
            this.retainIndex = retainIndex;
            this.propertiesIndex = propertiesIndex;
            this.builderIndex = builderIndex;
        }

        public MqttClientPublish getMqttPublish() {
            return this.mqttPublish;
        }

        public int getPayloadIndex() {
            return this.payloadIndex;
        }

        public int getRetainIndex() {
            return this.retainIndex;
        }

        public int getPropertiesIndex() {
            return this.propertiesIndex;
        }

        public int getBuilderIndex() {
            return this.builderIndex;
        }
    }
}

