/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec;

import org.dromara.mica.mqtt.codec.DecoderResult;
import org.dromara.mica.mqtt.codec.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.MqttConnAckVariableHeader;
import org.dromara.mica.mqtt.codec.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.MqttConnectPayload;
import org.dromara.mica.mqtt.codec.MqttConnectVariableHeader;
import org.dromara.mica.mqtt.codec.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttMessageIdVariableHeader;
import org.dromara.mica.mqtt.codec.MqttPubAckMessage;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttPublishVariableHeader;
import org.dromara.mica.mqtt.codec.MqttSubAckMessage;
import org.dromara.mica.mqtt.codec.MqttSubAckPayload;
import org.dromara.mica.mqtt.codec.MqttSubscribeMessage;
import org.dromara.mica.mqtt.codec.MqttSubscribePayload;
import org.dromara.mica.mqtt.codec.MqttUnsubAckMessage;
import org.dromara.mica.mqtt.codec.MqttUnsubAckPayload;
import org.dromara.mica.mqtt.codec.MqttUnsubscribeMessage;
import org.dromara.mica.mqtt.codec.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubAckPayload)payload);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (byte[])payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: {
                return new MqttMessage(mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure(cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure(cause));
    }

    private MqttMessageFactory() {
    }
}

