/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.dromara.mica.mqtt.codec.MqttCodecUtil;
import org.dromara.mica.mqtt.codec.MqttConnAckVariableHeader;
import org.dromara.mica.mqtt.codec.MqttConnectPayload;
import org.dromara.mica.mqtt.codec.MqttConnectReasonCode;
import org.dromara.mica.mqtt.codec.MqttConnectVariableHeader;
import org.dromara.mica.mqtt.codec.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttMessageFactory;
import org.dromara.mica.mqtt.codec.MqttMessageIdAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttProperties;
import org.dromara.mica.mqtt.codec.MqttPubReplyMessageVariableHeader;
import org.dromara.mica.mqtt.codec.MqttPublishVariableHeader;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.MqttReasonCodeAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.MqttSubAckPayload;
import org.dromara.mica.mqtt.codec.MqttSubscribePayload;
import org.dromara.mica.mqtt.codec.MqttSubscriptionOption;
import org.dromara.mica.mqtt.codec.MqttTopicSubscription;
import org.dromara.mica.mqtt.codec.MqttUnsubAckPayload;
import org.dromara.mica.mqtt.codec.MqttUnsubscribePayload;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.exception.DecoderException;
import org.dromara.mica.mqtt.codec.exception.MqttIdentifierRejectedException;
import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.utils.buffer.ByteBufferUtil;

public final class MqttDecoder {
    private static final String MQTT_FIXED_HEADER_KEY = "MQTT_F_H_K";
    private final int maxBytesInMessage;
    private final int maxClientIdLength;

    public MqttDecoder() {
        this(0xA00000);
    }

    public MqttDecoder(int maxBytesInMessage) {
        this(maxBytesInMessage, 64);
    }

    public MqttDecoder(int maxBytesInMessage, int maxClientIdLength) {
        this.maxBytesInMessage = maxBytesInMessage;
        this.maxClientIdLength = maxClientIdLength;
    }

    private static MqttFixedHeader decodeFixedHeader(ChannelContext ctx, ByteBuffer buffer) {
        short digit;
        short b1 = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
        MqttMessageType messageType = MqttMessageType.valueOf(b1 >> 4);
        boolean dupFlag = (b1 & 8) == 8;
        int qosLevel = (b1 & 6) >> 1;
        boolean retain = (b1 & 1) != 0;
        int remainingLength = 0;
        int multiplier = 1;
        int loops = 0;
        do {
            if (!buffer.hasRemaining()) {
                return null;
            }
            digit = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
            remainingLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0 && ++loops < 4);
        if (loops == 4 && (digit & 0x80) != 0) {
            throw new DecoderException("remaining length exceeds 4 digits (" + (Object)((Object)messageType) + ')');
        }
        int headLength = 1 + loops;
        MqttFixedHeader decodedFixedHeader = new MqttFixedHeader(messageType, dupFlag, MqttQoS.valueOf(qosLevel), retain, headLength, remainingLength);
        return MqttCodecUtil.validateFixedHeader(ctx, MqttCodecUtil.resetUnusedFields(decodedFixedHeader));
    }

    private static Result<MqttMessageIdAndPropertiesVariableHeader> decodeMessageIdAndPropertiesVariableHeader(ChannelContext ctx, ByteBuffer buffer, MqttFixedHeader mqttFixedHeader) {
        int mqtt5Consumed;
        MqttMessageIdAndPropertiesVariableHeader mqttVariableHeader;
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        int packetId = MqttDecoder.decodeMessageId(buffer, mqttFixedHeader);
        if (mqttVersion == MqttVersion.MQTT_5) {
            Result<MqttProperties> properties = MqttDecoder.decodeProperties(buffer);
            mqttVariableHeader = new MqttMessageIdAndPropertiesVariableHeader(packetId, (MqttProperties)((Result)properties).value);
            mqtt5Consumed = ((Result)properties).numberOfBytesConsumed;
        } else {
            mqttVariableHeader = new MqttMessageIdAndPropertiesVariableHeader(packetId, MqttProperties.NO_PROPERTIES);
            mqtt5Consumed = 0;
        }
        return new Result<MqttMessageIdAndPropertiesVariableHeader>(mqttVariableHeader, 2 + mqtt5Consumed);
    }

    private static int decodeMessageId(ByteBuffer buffer, MqttFixedHeader mqttFixedHeader) {
        int messageId = MqttDecoder.decodeMsbLsb(buffer);
        if (messageId == 0) {
            mqttFixedHeader.downgradeQos();
        }
        return messageId;
    }

    private static Result<MqttSubAckPayload> decodeSubAckPayload(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        int numberOfBytesConsumed;
        short[] grantedQos = new short[bytesRemainingInVariablePart];
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            short reasonCode;
            grantedQos[numberOfBytesConsumed] = reasonCode = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
        }
        return new Result<MqttSubAckPayload>(new MqttSubAckPayload(grantedQos), numberOfBytesConsumed);
    }

    private static Result<MqttUnsubAckPayload> decodeUnsubAckPayload(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        int numberOfBytesConsumed;
        short[] reasonCodes = new short[bytesRemainingInVariablePart];
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            short reasonCode;
            reasonCodes[numberOfBytesConsumed] = reasonCode = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
        }
        return new Result<MqttUnsubAckPayload>(new MqttUnsubAckPayload(reasonCodes), numberOfBytesConsumed);
    }

    private static Result<MqttConnectVariableHeader> decodeConnectionVariableHeader(ChannelContext ctx, ByteBuffer buffer) {
        MqttProperties properties;
        boolean cleanStart;
        Result<String> protoString = MqttDecoder.decodeString(buffer);
        int numberOfBytesConsumed = ((Result)protoString).numberOfBytesConsumed;
        byte protocolLevel = buffer.get();
        ++numberOfBytesConsumed;
        MqttVersion version = MqttVersion.fromProtocolNameAndLevel((String)((Result)protoString).value, protocolLevel);
        MqttCodecUtil.setMqttVersion(ctx, version);
        short b1 = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
        ++numberOfBytesConsumed;
        int keepAlive = MqttDecoder.decodeMsbLsb(buffer);
        numberOfBytesConsumed += 2;
        boolean hasUserName = (b1 & 0x80) == 128;
        boolean hasPassword = (b1 & 0x40) == 64;
        boolean willRetain = (b1 & 0x20) == 32;
        int willQos = (b1 & 0x18) >> 3;
        boolean willFlag = (b1 & 4) == 4;
        boolean bl = cleanStart = (b1 & 2) == 2;
        if (version == MqttVersion.MQTT_3_1_1 || version == MqttVersion.MQTT_5) {
            boolean zeroReservedFlag;
            boolean bl2 = zeroReservedFlag = (b1 & 1) == 0;
            if (!zeroReservedFlag) {
                throw new DecoderException("non-zero reserved flag");
            }
        }
        if (version == MqttVersion.MQTT_5) {
            Result<MqttProperties> propertiesResult = MqttDecoder.decodeProperties(buffer);
            properties = (MqttProperties)((Result)propertiesResult).value;
            numberOfBytesConsumed += ((Result)propertiesResult).numberOfBytesConsumed;
        } else {
            properties = MqttProperties.NO_PROPERTIES;
        }
        MqttConnectVariableHeader mqttConnectVariableHeader = new MqttConnectVariableHeader(version.protocolName(), version.protocolLevel(), hasUserName, hasPassword, willRetain, willQos, willFlag, cleanStart, keepAlive, properties);
        return new Result<MqttConnectVariableHeader>(mqttConnectVariableHeader, numberOfBytesConsumed);
    }

    private static Result<MqttConnAckVariableHeader> decodeConnAckVariableHeader(ChannelContext ctx, ByteBuffer buffer) {
        MqttProperties properties;
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        boolean sessionPresent = (ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer) & 1) == 1;
        byte returnCode = buffer.get();
        int numberOfBytesConsumed = 2;
        if (mqttVersion == MqttVersion.MQTT_5) {
            Result<MqttProperties> propertiesResult = MqttDecoder.decodeProperties(buffer);
            properties = (MqttProperties)((Result)propertiesResult).value;
            numberOfBytesConsumed += ((Result)propertiesResult).numberOfBytesConsumed;
        } else {
            properties = MqttProperties.NO_PROPERTIES;
        }
        MqttConnAckVariableHeader mqttConnAckVariableHeader = new MqttConnAckVariableHeader(MqttConnectReasonCode.valueOf(returnCode), sessionPresent, properties);
        return new Result<MqttConnAckVariableHeader>(mqttConnAckVariableHeader, numberOfBytesConsumed);
    }

    public Packet doDecode(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        MqttFixedHeader mqttFixedHeader = this.getOrDecodeMqttFixedHeader(ctx, buffer, readableLength);
        if (mqttFixedHeader == null) {
            return null;
        }
        int messageLength = mqttFixedHeader.getMessageLength();
        if (readableLength < messageLength) {
            return null;
        }
        ctx.remove(MQTT_FIXED_HEADER_KEY);
        MqttMessageType messageType = mqttFixedHeader.messageType();
        if (MqttMessageType.PINGREQ == messageType) {
            return MqttMessage.PINGREQ;
        }
        if (MqttMessageType.PINGRESP == messageType) {
            return MqttMessage.PINGRESP;
        }
        return this.decodeMqttMessage(ctx, buffer, messageType, mqttFixedHeader);
    }

    private Result<MqttPubReplyMessageVariableHeader> decodePubReplyMessage(ByteBuffer buffer, MqttFixedHeader mqttFixedHeader, int bytesRemainingInVariablePart) {
        int consumed;
        MqttPubReplyMessageVariableHeader mqttPubAckVariableHeader;
        int packetId = MqttDecoder.decodeMessageId(buffer, mqttFixedHeader);
        int packetIdNumberOfBytesConsumed = 2;
        if (bytesRemainingInVariablePart > 3) {
            byte reasonCode = buffer.get();
            Result<MqttProperties> properties = MqttDecoder.decodeProperties(buffer);
            mqttPubAckVariableHeader = new MqttPubReplyMessageVariableHeader(packetId, reasonCode, (MqttProperties)((Result)properties).value);
            consumed = 3 + ((Result)properties).numberOfBytesConsumed;
        } else if (bytesRemainingInVariablePart > 2) {
            byte reasonCode = buffer.get();
            mqttPubAckVariableHeader = new MqttPubReplyMessageVariableHeader(packetId, reasonCode, MqttProperties.NO_PROPERTIES);
            consumed = 3;
        } else {
            mqttPubAckVariableHeader = new MqttPubReplyMessageVariableHeader(packetId, 0, MqttProperties.NO_PROPERTIES);
            consumed = 2;
        }
        return new Result<MqttPubReplyMessageVariableHeader>(mqttPubAckVariableHeader, consumed);
    }

    private Result<MqttReasonCodeAndPropertiesVariableHeader> decodeReasonCodeAndPropertiesVariableHeader(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        int consumed;
        MqttProperties properties;
        byte reasonCode;
        if (bytesRemainingInVariablePart > 1) {
            reasonCode = buffer.get();
            Result<MqttProperties> propertiesResult = MqttDecoder.decodeProperties(buffer);
            properties = (MqttProperties)((Result)propertiesResult).value;
            consumed = 1 + ((Result)propertiesResult).numberOfBytesConsumed;
        } else if (bytesRemainingInVariablePart > 0) {
            reasonCode = buffer.get();
            properties = MqttProperties.NO_PROPERTIES;
            consumed = 1;
        } else {
            reasonCode = 0;
            properties = MqttProperties.NO_PROPERTIES;
            consumed = 0;
        }
        MqttReasonCodeAndPropertiesVariableHeader mqttReasonAndPropsVariableHeader = new MqttReasonCodeAndPropertiesVariableHeader(reasonCode, properties);
        return new Result<MqttReasonCodeAndPropertiesVariableHeader>(mqttReasonAndPropsVariableHeader, consumed);
    }

    private MqttFixedHeader getOrDecodeMqttFixedHeader(ChannelContext ctx, ByteBuffer buffer, int readableLength) {
        MqttFixedHeader mqttFixedHeader = (MqttFixedHeader)ctx.get(MQTT_FIXED_HEADER_KEY);
        if (mqttFixedHeader != null) {
            ByteBufferUtil.skipBytes((ByteBuffer)buffer, (int)mqttFixedHeader.headLength());
            return mqttFixedHeader;
        }
        if (readableLength < 2) {
            return null;
        }
        mqttFixedHeader = MqttDecoder.decodeFixedHeader(ctx, buffer);
        if (mqttFixedHeader == null) {
            return null;
        }
        int messageLength = mqttFixedHeader.getMessageLength();
        if (messageLength > this.maxBytesInMessage) {
            throw new DecoderException("too large message: " + messageLength + " bytes but maxBytesInMessage is " + this.maxBytesInMessage);
        }
        ctx.set(MQTT_FIXED_HEADER_KEY, (Object)mqttFixedHeader);
        if (readableLength < messageLength) {
            ctx.setPacketNeededLength(Integer.valueOf(messageLength));
            return null;
        }
        return mqttFixedHeader;
    }

    private MqttMessage decodeMqttMessage(ChannelContext ctx, ByteBuffer buffer, MqttMessageType messageType, MqttFixedHeader mqttFixedHeader) {
        Object variableHeader;
        Result<?> decodedVariableHeader;
        int bytesRemainingInVariablePart = mqttFixedHeader.remainingLength();
        try {
            decodedVariableHeader = this.decodeVariableHeader(ctx, buffer, messageType, mqttFixedHeader, bytesRemainingInVariablePart);
            variableHeader = ((Result)decodedVariableHeader).value;
        }
        catch (Exception cause) {
            throw new DecoderException(cause);
        }
        Result<?> decodedPayload = MqttDecoder.decodePayload(buffer, this.maxClientIdLength, messageType, bytesRemainingInVariablePart -= ((Result)decodedVariableHeader).numberOfBytesConsumed, variableHeader);
        if ((bytesRemainingInVariablePart -= ((Result)decodedPayload).numberOfBytesConsumed) != 0) {
            throw new DecoderException("non-zero remaining payload bytes: " + bytesRemainingInVariablePart + " (" + (Object)((Object)mqttFixedHeader.messageType()) + ')');
        }
        return MqttMessageFactory.newMessage(mqttFixedHeader, variableHeader, ((Result)decodedPayload).value);
    }

    private static Result<?> decodePayload(ByteBuffer buffer, int maxClientIdLength, MqttMessageType messageType, int bytesRemainingInVariablePart, Object variableHeader) {
        switch (messageType) {
            case CONNECT: {
                return MqttDecoder.decodeConnectionPayload(buffer, maxClientIdLength, (MqttConnectVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return MqttDecoder.decodeSubscribePayload(buffer, bytesRemainingInVariablePart);
            }
            case SUBACK: {
                return MqttDecoder.decodeSubAckPayload(buffer, bytesRemainingInVariablePart);
            }
            case UNSUBSCRIBE: {
                return MqttDecoder.decodeUnsubscribePayload(buffer, bytesRemainingInVariablePart);
            }
            case UNSUBACK: {
                return MqttDecoder.decodeUnsubAckPayload(buffer, bytesRemainingInVariablePart);
            }
            case PUBLISH: {
                return MqttDecoder.decodePublishPayload(buffer, bytesRemainingInVariablePart);
            }
        }
        return new Result<Object>(null, 0);
    }

    private static Result<MqttConnectPayload> decodeConnectionPayload(ByteBuffer buffer, int maxClientIdLength, MqttConnectVariableHeader mqttConnectVariableHeader) {
        MqttProperties willProperties;
        Result<String> decodedClientId = MqttDecoder.decodeString(buffer);
        String decodedClientIdValue = (String)((Result)decodedClientId).value;
        MqttVersion mqttVersion = MqttVersion.fromProtocolNameAndLevel(mqttConnectVariableHeader.name(), (byte)mqttConnectVariableHeader.version());
        if (!MqttCodecUtil.isValidClientId(mqttVersion, maxClientIdLength, decodedClientIdValue)) {
            throw new MqttIdentifierRejectedException("invalid clientIdentifier: " + decodedClientIdValue);
        }
        int numberOfBytesConsumed = ((Result)decodedClientId).numberOfBytesConsumed;
        Result<String> decodedWillTopic = null;
        byte[] decodedWillMessage = null;
        if (mqttConnectVariableHeader.isWillFlag()) {
            if (mqttVersion == MqttVersion.MQTT_5) {
                Result<MqttProperties> propertiesResult = MqttDecoder.decodeProperties(buffer);
                willProperties = (MqttProperties)((Result)propertiesResult).value;
                numberOfBytesConsumed += ((Result)propertiesResult).numberOfBytesConsumed;
            } else {
                willProperties = MqttProperties.NO_PROPERTIES;
            }
            decodedWillTopic = MqttDecoder.decodeString(buffer, 0, Short.MAX_VALUE);
            numberOfBytesConsumed += ((Result)decodedWillTopic).numberOfBytesConsumed;
            decodedWillMessage = MqttDecoder.decodeByteArray(buffer);
            numberOfBytesConsumed += decodedWillMessage.length + 2;
        } else {
            willProperties = MqttProperties.NO_PROPERTIES;
        }
        Result<String> decodedUserName = null;
        byte[] decodedPassword = null;
        if (mqttConnectVariableHeader.hasUsername()) {
            decodedUserName = MqttDecoder.decodeString(buffer);
            numberOfBytesConsumed += ((Result)decodedUserName).numberOfBytesConsumed;
        }
        if (mqttConnectVariableHeader.hasPassword()) {
            decodedPassword = MqttDecoder.decodeByteArray(buffer);
            numberOfBytesConsumed += decodedPassword.length + 2;
        }
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload((String)((Result)decodedClientId).value, willProperties, decodedWillTopic != null ? (String)((Result)decodedWillTopic).value : null, decodedWillMessage, decodedUserName != null ? (String)((Result)decodedUserName).value : null, decodedPassword);
        return new Result<MqttConnectPayload>(mqttConnectPayload, numberOfBytesConsumed);
    }

    private static Result<MqttSubscribePayload> decodeSubscribePayload(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        int numberOfBytesConsumed;
        ArrayList<MqttTopicSubscription> subscribeTopics = new ArrayList<MqttTopicSubscription>();
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; ++numberOfBytesConsumed) {
            Result<String> decodedTopicName = MqttDecoder.decodeString(buffer);
            numberOfBytesConsumed += ((Result)decodedTopicName).numberOfBytesConsumed;
            short optionByte = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
            MqttQoS qos = MqttQoS.valueOf(optionByte & 3);
            boolean noLocal = (optionByte & 4) >> 2 == 1;
            boolean retainAsPublished = (optionByte & 8) >> 3 == 1;
            MqttSubscriptionOption.RetainedHandlingPolicy retainHandling = MqttSubscriptionOption.RetainedHandlingPolicy.valueOf((optionByte & 0x30) >> 4);
            MqttSubscriptionOption subscriptionOption = new MqttSubscriptionOption(qos, noLocal, retainAsPublished, retainHandling);
            subscribeTopics.add(new MqttTopicSubscription((String)((Result)decodedTopicName).value, subscriptionOption));
        }
        return new Result<MqttSubscribePayload>(new MqttSubscribePayload(subscribeTopics), numberOfBytesConsumed);
    }

    private Result<?> decodeVariableHeader(ChannelContext ctx, ByteBuffer buffer, MqttMessageType messageType, MqttFixedHeader mqttFixedHeader, int bytesRemainingInVariablePart) {
        switch (messageType) {
            case CONNECT: {
                return MqttDecoder.decodeConnectionVariableHeader(ctx, buffer);
            }
            case CONNACK: {
                return MqttDecoder.decodeConnAckVariableHeader(ctx, buffer);
            }
            case SUBSCRIBE: 
            case SUBACK: 
            case UNSUBSCRIBE: 
            case UNSUBACK: {
                return MqttDecoder.decodeMessageIdAndPropertiesVariableHeader(ctx, buffer, mqttFixedHeader);
            }
            case PUBACK: 
            case PUBREC: 
            case PUBCOMP: 
            case PUBREL: {
                return this.decodePubReplyMessage(buffer, mqttFixedHeader, bytesRemainingInVariablePart);
            }
            case PUBLISH: {
                return this.decodePublishVariableHeader(ctx, buffer, mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return this.decodeReasonCodeAndPropertiesVariableHeader(buffer, bytesRemainingInVariablePart);
            }
        }
        throw new DecoderException("Unknown message type: " + (Object)((Object)messageType));
    }

    private Result<MqttPublishVariableHeader> decodePublishVariableHeader(ChannelContext ctx, ByteBuffer buffer, MqttFixedHeader mqttFixedHeader) {
        MqttProperties properties;
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion(ctx);
        Result<String> decodedTopic = MqttDecoder.decodeString(buffer);
        if (!MqttCodecUtil.isValidPublishTopicName((String)((Result)decodedTopic).value)) {
            throw new DecoderException("invalid publish topic name: " + (String)((Result)decodedTopic).value + " (contains wildcards)");
        }
        int numberOfBytesConsumed = ((Result)decodedTopic).numberOfBytesConsumed;
        int messageId = -1;
        if (mqttFixedHeader.qosLevel().value() > 0) {
            messageId = MqttDecoder.decodeMessageId(buffer, mqttFixedHeader);
            numberOfBytesConsumed += 2;
        }
        if (mqttVersion == MqttVersion.MQTT_5) {
            Result<MqttProperties> propertiesResult = MqttDecoder.decodeProperties(buffer);
            properties = (MqttProperties)((Result)propertiesResult).value;
            numberOfBytesConsumed += ((Result)propertiesResult).numberOfBytesConsumed;
        } else {
            properties = MqttProperties.NO_PROPERTIES;
        }
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader((String)((Result)decodedTopic).value, messageId, properties);
        return new Result<MqttPublishVariableHeader>(mqttPublishVariableHeader, numberOfBytesConsumed);
    }

    private static Result<MqttUnsubscribePayload> decodeUnsubscribePayload(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        int numberOfBytesConsumed;
        Result<String> decodedTopicName;
        ArrayList<String> unsubscribeTopics = new ArrayList<String>();
        for (numberOfBytesConsumed = 0; numberOfBytesConsumed < bytesRemainingInVariablePart; numberOfBytesConsumed += ((Result)decodedTopicName).numberOfBytesConsumed) {
            decodedTopicName = MqttDecoder.decodeString(buffer);
            unsubscribeTopics.add((String)((Result)decodedTopicName).value);
        }
        return new Result<MqttUnsubscribePayload>(new MqttUnsubscribePayload(unsubscribeTopics), numberOfBytesConsumed);
    }

    private static Result<byte[]> decodePublishPayload(ByteBuffer buffer, int bytesRemainingInVariablePart) {
        byte[] payload = new byte[bytesRemainingInVariablePart];
        buffer.get(payload, 0, bytesRemainingInVariablePart);
        return new Result<byte[]>(payload, bytesRemainingInVariablePart);
    }

    private static Result<String> decodeString(ByteBuffer buffer) {
        return MqttDecoder.decodeString(buffer, 0, Integer.MAX_VALUE);
    }

    private static Result<String> decodeString(ByteBuffer buffer, int minBytes, int maxBytes) {
        int size = MqttDecoder.decodeMsbLsb(buffer);
        int numberOfBytesConsumed = 2;
        if (size < minBytes || size > maxBytes) {
            ByteBufferUtil.skipBytes((ByteBuffer)buffer, (int)size);
            return new Result<Object>(null, numberOfBytesConsumed += size);
        }
        String s = new String(buffer.array(), buffer.position(), size, StandardCharsets.UTF_8);
        ByteBufferUtil.skipBytes((ByteBuffer)buffer, (int)size);
        return new Result<String>(s, numberOfBytesConsumed += size);
    }

    private static byte[] decodeByteArray(ByteBuffer buffer) {
        int size = MqttDecoder.decodeMsbLsb(buffer);
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }

    private static long packInts(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    private static int unpackA(long ints) {
        return (int)(ints >> 32);
    }

    private static int unpackB(long ints) {
        return (int)ints;
    }

    private static int decodeMsbLsb(ByteBuffer buffer) {
        short lsbSize;
        int min = 0;
        int max = 65535;
        short msbSize = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
        int result = msbSize << 8 | (lsbSize = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer));
        if (result < min || result > max) {
            result = -1;
        }
        return result;
    }

    private static long decodeVariableByteInteger(ByteBuffer buffer) {
        short digit;
        int remainingLength = 0;
        int multiplier = 1;
        int loops = 0;
        do {
            digit = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
            remainingLength += (digit & 0x7F) * multiplier;
            multiplier *= 128;
        } while ((digit & 0x80) != 0 && ++loops < 4);
        if (loops == 4 && (digit & 0x80) != 0) {
            throw new DecoderException("MQTT protocol limits Remaining Length to 4 bytes");
        }
        return MqttDecoder.packInts(remainingLength, loops);
    }

    private static Result<MqttProperties> decodeProperties(ByteBuffer buffer) {
        long propertiesLength = MqttDecoder.decodeVariableByteInteger(buffer);
        int totalPropertiesLength = MqttDecoder.unpackA(propertiesLength);
        int numberOfBytesConsumed = MqttDecoder.unpackB(propertiesLength);
        MqttProperties decodedProperties = new MqttProperties();
        block9: while (numberOfBytesConsumed < totalPropertiesLength) {
            long propertyId = MqttDecoder.decodeVariableByteInteger(buffer);
            int propertyIdValue = MqttDecoder.unpackA(propertyId);
            numberOfBytesConsumed += MqttDecoder.unpackB(propertyId);
            MqttPropertyType propertyType = MqttPropertyType.valueOf(propertyIdValue);
            switch (propertyType) {
                case PAYLOAD_FORMAT_INDICATOR: 
                case REQUEST_PROBLEM_INFORMATION: 
                case REQUEST_RESPONSE_INFORMATION: 
                case MAXIMUM_QOS: 
                case RETAIN_AVAILABLE: 
                case WILDCARD_SUBSCRIPTION_AVAILABLE: 
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    short b1 = ByteBufferUtil.readUnsignedByte((ByteBuffer)buffer);
                    ++numberOfBytesConsumed;
                    decodedProperties.add(new IntegerProperty(propertyIdValue, Integer.valueOf(b1)));
                    continue block9;
                }
                case SERVER_KEEP_ALIVE: 
                case RECEIVE_MAXIMUM: 
                case TOPIC_ALIAS_MAXIMUM: 
                case TOPIC_ALIAS: {
                    int int2BytesResult = MqttDecoder.decodeMsbLsb(buffer);
                    numberOfBytesConsumed += 2;
                    decodedProperties.add(new IntegerProperty(propertyIdValue, (Integer)int2BytesResult));
                    continue block9;
                }
                case PUBLICATION_EXPIRY_INTERVAL: 
                case SESSION_EXPIRY_INTERVAL: 
                case WILL_DELAY_INTERVAL: 
                case MAXIMUM_PACKET_SIZE: {
                    int maxPacketSize = buffer.getInt();
                    numberOfBytesConsumed += 4;
                    decodedProperties.add(new IntegerProperty(propertyIdValue, (Integer)maxPacketSize));
                    continue block9;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    long vbIntegerResult = MqttDecoder.decodeVariableByteInteger(buffer);
                    numberOfBytesConsumed += MqttDecoder.unpackB(vbIntegerResult);
                    decodedProperties.add(new IntegerProperty(propertyIdValue, (Integer)MqttDecoder.unpackA(vbIntegerResult)));
                    continue block9;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: 
                case ASSIGNED_CLIENT_IDENTIFIER: 
                case AUTHENTICATION_METHOD: 
                case RESPONSE_INFORMATION: 
                case SERVER_REFERENCE: 
                case REASON_STRING: {
                    Result<String> stringResult = MqttDecoder.decodeString(buffer);
                    numberOfBytesConsumed += ((Result)stringResult).numberOfBytesConsumed;
                    decodedProperties.add(new StringProperty(propertyIdValue, (String)((Result)stringResult).value));
                    continue block9;
                }
                case USER_PROPERTY: {
                    Result<String> keyResult = MqttDecoder.decodeString(buffer);
                    Result<String> valueResult = MqttDecoder.decodeString(buffer);
                    numberOfBytesConsumed += ((Result)keyResult).numberOfBytesConsumed;
                    numberOfBytesConsumed += ((Result)valueResult).numberOfBytesConsumed;
                    decodedProperties.add(new UserProperty((String)((Result)keyResult).value, (String)((Result)valueResult).value));
                    continue block9;
                }
                case CORRELATION_DATA: 
                case AUTHENTICATION_DATA: {
                    byte[] binaryDataResult = MqttDecoder.decodeByteArray(buffer);
                    numberOfBytesConsumed += binaryDataResult.length + 2;
                    decodedProperties.add(new BinaryProperty(propertyIdValue, binaryDataResult));
                    continue block9;
                }
            }
            throw new DecoderException("Unknown property type: " + (Object)((Object)propertyType));
        }
        return new Result<MqttProperties>(decodedProperties, numberOfBytesConsumed);
    }

    private static final class Result<T> {
        private final T value;
        private final int numberOfBytesConsumed;

        Result(T value, int numberOfBytesConsumed) {
            this.value = value;
            this.numberOfBytesConsumed = numberOfBytesConsumed;
        }
    }
}

