/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.codes.MqttConnectReasonCode;
import org.dromara.mica.mqtt.codec.message.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttConnAckVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.properties.MqttConnAckProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttConnAckBuilder {
    private MqttConnectReasonCode returnCode;
    private boolean sessionPresent;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttConnAckBuilder() {
    }

    public MqttConnAckBuilder returnCode(MqttConnectReasonCode returnCode) {
        this.returnCode = returnCode;
        return this;
    }

    public MqttConnAckBuilder sessionPresent(boolean sessionPresent) {
        this.sessionPresent = sessionPresent;
        return this;
    }

    public MqttConnAckBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttConnAckBuilder properties(Consumer<MqttConnAckProperties> consumer) {
        MqttConnAckProperties connAckProperties = new MqttConnAckProperties();
        consumer.accept(connAckProperties);
        return this.properties(connAckProperties.getProperties());
    }

    public MqttConnAckMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.QOS0, false, 0);
        MqttConnAckVariableHeader mqttConnAckVariableHeader = new MqttConnAckVariableHeader(this.returnCode, this.sessionPresent, this.properties);
        return new MqttConnAckMessage(mqttFixedHeader, mqttConnAckVariableHeader);
    }
}

