/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.message.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttConnectVariableHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.payload.MqttConnectPayload;
import org.dromara.mica.mqtt.codec.message.properties.MqttConnectProperties;
import org.dromara.mica.mqtt.codec.message.properties.MqttWillPublishProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttConnectBuilder {
    private MqttVersion version = MqttVersion.MQTT_3_1_1;
    private String clientId;
    private boolean cleanStart;
    private boolean hasUser;
    private boolean hasPassword;
    private int keepAliveSecs;
    private MqttProperties willProperties = MqttProperties.NO_PROPERTIES;
    private boolean willFlag;
    private boolean willRetain;
    private MqttQoS willQos = MqttQoS.QOS0;
    private String willTopic;
    private byte[] willMessage;
    private String username;
    private byte[] password;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttConnectBuilder() {
    }

    public MqttConnectBuilder protocolVersion(MqttVersion version) {
        this.version = version;
        return this;
    }

    public MqttConnectBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MqttConnectBuilder cleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
        return this;
    }

    public MqttConnectBuilder keepAlive(int keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
        return this;
    }

    public MqttConnectBuilder willFlag(boolean willFlag) {
        this.willFlag = willFlag;
        return this;
    }

    public MqttConnectBuilder willQoS(MqttQoS willQos) {
        this.willQos = willQos;
        return this;
    }

    public MqttConnectBuilder willTopic(String willTopic) {
        this.willTopic = willTopic;
        return this;
    }

    public MqttConnectBuilder willMessage(byte[] willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public MqttConnectBuilder willRetain(boolean willRetain) {
        this.willRetain = willRetain;
        return this;
    }

    public MqttConnectBuilder willProperties(MqttProperties willProperties) {
        this.willProperties = willProperties;
        return this;
    }

    public MqttConnectBuilder willProperties(Consumer<MqttWillPublishProperties> consumer) {
        MqttWillPublishProperties willPublishProperties = new MqttWillPublishProperties();
        consumer.accept(willPublishProperties);
        return this.willProperties(willPublishProperties.getProperties());
    }

    public MqttConnectBuilder hasUser(boolean value) {
        this.hasUser = value;
        return this;
    }

    public MqttConnectBuilder hasPassword(boolean value) {
        this.hasPassword = value;
        return this;
    }

    public MqttConnectBuilder username(String username) {
        this.hasUser = username != null;
        this.username = username;
        return this;
    }

    public MqttConnectBuilder password(byte[] password) {
        this.hasPassword = password != null;
        this.password = password;
        return this;
    }

    public MqttConnectBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttConnectBuilder properties(Consumer<MqttConnectProperties> consumer) {
        MqttConnectProperties connectProperties = new MqttConnectProperties();
        consumer.accept(connectProperties);
        return this.properties(connectProperties.getProperties());
    }

    public MqttConnectMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.CONNECT, false, MqttQoS.QOS0, false, 0);
        MqttConnectVariableHeader mqttConnectVariableHeader = new MqttConnectVariableHeader(this.version.protocolName(), this.version.protocolLevel(), this.hasUser, this.hasPassword, this.willRetain, this.willQos.value(), this.willFlag, this.cleanStart, this.keepAliveSecs, this.properties);
        MqttConnectPayload mqttConnectPayload = new MqttConnectPayload(this.clientId, this.willProperties, this.willTopic, this.willMessage, this.username, this.password);
        return new MqttConnectMessage(mqttFixedHeader, mqttConnectVariableHeader, mqttConnectPayload);
    }
}

