/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.codes.MqttPubAckReasonCode;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttPubReplyMessageVariableHeader;
import org.dromara.mica.mqtt.codec.message.properties.MqttPubAckProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttPubAckBuilder {
    private int packetId;
    private MqttPubAckReasonCode reasonCode;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttPubAckBuilder() {
    }

    public MqttPubAckBuilder reasonCode(byte reasonCode) {
        this.reasonCode = MqttPubAckReasonCode.valueOf(reasonCode);
        return this;
    }

    public MqttPubAckBuilder reasonCode(MqttPubAckReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public MqttPubAckBuilder packetId(int packetId) {
        this.packetId = packetId;
        return this;
    }

    public MqttPubAckBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttPubAckBuilder properties(Consumer<MqttPubAckProperties> consumer) {
        MqttPubAckProperties pubAckProperties = new MqttPubAckProperties();
        consumer.accept(pubAckProperties);
        return this.properties(pubAckProperties.getProperties());
    }

    public MqttMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.QOS0, false, 0);
        MqttPubReplyMessageVariableHeader mqttPubAckVariableHeader = new MqttPubReplyMessageVariableHeader(this.packetId, this.reasonCode != null ? this.reasonCode.value() : (byte)0, this.properties);
        return new MqttMessage(mqttFixedHeader, mqttPubAckVariableHeader);
    }
}

