/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.MqttSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.builder.MqttSubscriptionOption;
import org.dromara.mica.mqtt.codec.message.builder.MqttTopicSubscription;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.payload.MqttSubscribePayload;
import org.dromara.mica.mqtt.codec.message.properties.MqttSubscribeProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttSubscribeBuilder {
    private final List<MqttTopicSubscription> subscriptions;
    private int messageId;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttSubscribeBuilder() {
        this.subscriptions = new ArrayList<MqttTopicSubscription>(5);
    }

    public MqttSubscribeBuilder addSubscription(MqttTopicSubscription subscription) {
        this.subscriptions.add(subscription);
        return this;
    }

    public MqttSubscribeBuilder addSubscription(MqttQoS qos, String topic) {
        return this.addSubscription(new MqttTopicSubscription(topic, qos));
    }

    public MqttSubscribeBuilder addSubscription(String topic, MqttSubscriptionOption option) {
        return this.addSubscription(new MqttTopicSubscription(topic, option));
    }

    public MqttSubscribeBuilder addSubscriptions(Collection<MqttTopicSubscription> subscriptionColl) {
        this.subscriptions.addAll(subscriptionColl);
        return this;
    }

    public MqttSubscribeBuilder messageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public MqttSubscribeBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttSubscribeBuilder properties(Consumer<MqttSubscribeProperties> consumer) {
        MqttSubscribeProperties subscribeProperties = new MqttSubscribeProperties();
        consumer.accept(subscribeProperties);
        return this.properties(subscribeProperties.getProperties());
    }

    public MqttSubscribeMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.QOS1, false, 0);
        MqttMessageIdAndPropertiesVariableHeader mqttVariableHeader = new MqttMessageIdAndPropertiesVariableHeader(this.messageId, this.properties);
        MqttSubscribePayload mqttSubscribePayload = new MqttSubscribePayload(this.subscriptions);
        return new MqttSubscribeMessage(mqttFixedHeader, mqttVariableHeader, mqttSubscribePayload);
    }
}

