/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.codes.MqttUnSubAckReasonCode;
import org.dromara.mica.mqtt.codec.message.MqttUnSubAckMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.payload.MqttUnsubAckPayload;
import org.dromara.mica.mqtt.codec.message.properties.MqttUnSubAckProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttUnSubAckBuilder {
    private final List<MqttUnSubAckReasonCode> reasonCodes = new ArrayList<MqttUnSubAckReasonCode>();
    private int packetId;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttUnSubAckBuilder() {
    }

    public MqttUnSubAckBuilder packetId(int packetId) {
        this.packetId = packetId;
        return this;
    }

    public MqttUnSubAckBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttUnSubAckBuilder properties(Consumer<MqttUnSubAckProperties> consumer) {
        MqttUnSubAckProperties unSubAckProperties = new MqttUnSubAckProperties();
        consumer.accept(unSubAckProperties);
        return this.properties(unSubAckProperties.getProperties());
    }

    public MqttUnSubAckBuilder addReasonCode(short reasonCode) {
        this.reasonCodes.add(MqttUnSubAckReasonCode.values()[reasonCode]);
        return this;
    }

    public MqttUnSubAckBuilder addReasonCode(MqttUnSubAckReasonCode reasonCode) {
        this.reasonCodes.add(reasonCode);
        return this;
    }

    public MqttUnSubAckBuilder addReasonCodes(Short ... reasonCodes) {
        for (Short reasonCode : reasonCodes) {
            this.reasonCodes.add(MqttUnSubAckReasonCode.values()[reasonCode]);
        }
        return this;
    }

    public MqttUnSubAckBuilder addReasonCodes(MqttUnSubAckReasonCode ... reasonCodes) {
        this.reasonCodes.addAll(Arrays.asList(reasonCodes));
        return this;
    }

    public MqttUnSubAckMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.QOS0, false, 0);
        MqttMessageIdAndPropertiesVariableHeader mqttSubAckVariableHeader = new MqttMessageIdAndPropertiesVariableHeader(this.packetId, this.properties);
        ArrayList<Short> reasonCodeValues = new ArrayList<Short>();
        for (MqttUnSubAckReasonCode reasonCode : this.reasonCodes) {
            reasonCodeValues.add(Short.valueOf(reasonCode.value()));
        }
        MqttUnsubAckPayload subAckPayload = new MqttUnsubAckPayload(reasonCodeValues);
        return new MqttUnSubAckMessage(mqttFixedHeader, mqttSubAckVariableHeader, subAckPayload);
    }
}

