/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.MqttUnSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.payload.MqttUnsubscribePayload;
import org.dromara.mica.mqtt.codec.message.properties.MqttUnSubscribeProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttUnSubscribeBuilder {
    private final List<String> topicFilters;
    private int messageId;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    MqttUnSubscribeBuilder() {
        this.topicFilters = new ArrayList<String>(5);
    }

    public MqttUnSubscribeBuilder addTopicFilter(String topic) {
        this.topicFilters.add(topic);
        return this;
    }

    public MqttUnSubscribeBuilder addTopicFilters(Collection<String> topicColl) {
        this.topicFilters.addAll(topicColl);
        return this;
    }

    public MqttUnSubscribeBuilder messageId(int messageId) {
        this.messageId = messageId;
        return this;
    }

    public MqttUnSubscribeBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttUnSubscribeBuilder properties(Consumer<MqttUnSubscribeProperties> consumer) {
        MqttUnSubscribeProperties unSubscribeProperties = new MqttUnSubscribeProperties();
        consumer.accept(unSubscribeProperties);
        return this.properties(unSubscribeProperties.getProperties());
    }

    public MqttUnSubscribeMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.QOS1, false, 0);
        MqttMessageIdAndPropertiesVariableHeader mqttVariableHeader = new MqttMessageIdAndPropertiesVariableHeader(this.messageId, this.properties);
        MqttUnsubscribePayload mqttSubscribePayload = new MqttUnsubscribePayload(this.topicFilters);
        return new MqttUnSubscribeMessage(mqttFixedHeader, mqttVariableHeader, mqttSubscribePayload);
    }
}

