/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec;

import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.codec.exception.DecoderException;
import org.dromara.mica.mqtt.codec.exception.MqttUnacceptableProtocolVersionException;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;

public final class MqttCodecUtil {
    private static final Logger logger = LoggerFactory.getLogger(MqttCodecUtil.class);
    public static final char TOPIC_LAYER = '/';
    public static final char TOPIC_WILDCARDS_ONE = '+';
    public static final char TOPIC_WILDCARDS_MORE = '#';
    private static final String MQTT_VERSION_KEY = "MQTT_V";

    private MqttCodecUtil() {
    }

    public static MqttVersion getMqttVersion(ChannelContext ctx) {
        MqttVersion version = (MqttVersion)((Object)ctx.get(MQTT_VERSION_KEY));
        if (version == null) {
            return MqttVersion.MQTT_3_1_1;
        }
        return version;
    }

    protected static void setMqttVersion(ChannelContext ctx, MqttVersion version) {
        ctx.set(MQTT_VERSION_KEY, (Object)version);
    }

    public static boolean isTopicFilter(String topicFilter) {
        for (int i = topicFilter.length() - 1; i >= 0; --i) {
            char ch = topicFilter.charAt(i);
            if (Character.isWhitespace(ch)) {
                logger.warn("\u6ce8\u610f\uff1atopic:[{}] \u4e2d\u5305\u542b\u7a7a\u767d\u5b57\u7b26\u4e32:[{}]\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e", (Object)topicFilter, (Object)Character.valueOf(ch));
                continue;
            }
            if ('+' != ch && '#' != ch) continue;
            return true;
        }
        return false;
    }

    protected static boolean isValidClientId(MqttVersion mqttVersion, int maxClientIdLength, String clientId) {
        if (clientId == null) {
            return false;
        }
        switch (mqttVersion) {
            case MQTT_3_1: {
                return !clientId.isEmpty() && clientId.length() <= maxClientIdLength;
            }
            case MQTT_3_1_1: 
            case MQTT_5: {
                return true;
            }
        }
        throw new MqttUnacceptableProtocolVersionException((Object)((Object)mqttVersion) + " is unknown mqtt version");
    }

    protected static MqttFixedHeader validateFixedHeader(ChannelContext ctx, MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (MqttQoS.QOS1 != mqttFixedHeader.qosLevel()) {
                    throw new DecoderException(mqttFixedHeader.messageType().name() + " message must have QoS 1");
                }
                return mqttFixedHeader;
            }
            case AUTH: {
                if (MqttVersion.MQTT_5 != MqttCodecUtil.getMqttVersion(ctx)) {
                    throw new DecoderException("AUTH message requires at least MQTT 5");
                }
                return mqttFixedHeader;
            }
        }
        return mqttFixedHeader;
    }

    protected static MqttFixedHeader resetUnusedFields(MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: 
            case CONNACK: 
            case PUBACK: 
            case PUBREC: 
            case PUBCOMP: 
            case SUBACK: 
            case UNSUBACK: 
            case PINGREQ: 
            case PINGRESP: 
            case DISCONNECT: {
                if (mqttFixedHeader.isDup() || MqttQoS.QOS0 != mqttFixedHeader.qosLevel() || mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), false, MqttQoS.QOS0, false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
            case PUBREL: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                if (mqttFixedHeader.isRetain()) {
                    return new MqttFixedHeader(mqttFixedHeader.messageType(), mqttFixedHeader.isDup(), mqttFixedHeader.qosLevel(), false, mqttFixedHeader.remainingLength());
                }
                return mqttFixedHeader;
            }
        }
        return mqttFixedHeader;
    }
}

