/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.codes.MqttAuthReasonCode;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttReasonCodeAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.properties.MqttAuthProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttAuthBuilder {
    private MqttAuthReasonCode reasonCode;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    public MqttAuthBuilder reasonCode(MqttAuthReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public MqttAuthBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttAuthBuilder properties(Consumer<MqttAuthProperties> consumer) {
        MqttAuthProperties authProperties = new MqttAuthProperties();
        consumer.accept(authProperties);
        return this.properties(authProperties.getProperties());
    }

    public MqttMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.AUTH, false, MqttQoS.QOS0, false, 0);
        MqttReasonCodeAndPropertiesVariableHeader mqttAuthVariableHeader = new MqttReasonCodeAndPropertiesVariableHeader(this.reasonCode.value(), this.properties);
        return new MqttMessage(mqttFixedHeader, mqttAuthVariableHeader);
    }
}

