/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.header;

import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttConnectVariableHeader {
    private final String name;
    private final int version;
    private final boolean hasUsername;
    private final boolean hasPassword;
    private final boolean isWillRetain;
    private final int willQos;
    private final boolean isWillFlag;
    private final boolean isCleanStart;
    private final int keepAliveTimeSeconds;
    private final MqttProperties properties;

    public MqttConnectVariableHeader(String name, int version, boolean hasUsername, boolean hasPassword, boolean isWillRetain, int willQos, boolean isWillFlag, boolean isCleanStart, int keepAliveTimeSeconds) {
        this(name, version, hasUsername, hasPassword, isWillRetain, willQos, isWillFlag, isCleanStart, keepAliveTimeSeconds, MqttProperties.NO_PROPERTIES);
    }

    public MqttConnectVariableHeader(String name, int version, boolean hasUsername, boolean hasPassword, boolean isWillRetain, int willQos, boolean isWillFlag, boolean isCleanStart, int keepAliveTimeSeconds, MqttProperties properties) {
        this.name = name;
        this.version = version;
        this.hasUsername = hasUsername;
        this.hasPassword = hasPassword;
        this.isWillRetain = isWillRetain;
        this.willQos = willQos;
        this.isWillFlag = isWillFlag;
        this.isCleanStart = isCleanStart;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
        this.properties = MqttProperties.withEmptyDefaults(properties);
    }

    public String name() {
        return this.name;
    }

    public int version() {
        return this.version;
    }

    public boolean hasUsername() {
        return this.hasUsername;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean isWillRetain() {
        return this.isWillRetain;
    }

    public int willQos() {
        return this.willQos;
    }

    public boolean isWillFlag() {
        return this.isWillFlag;
    }

    public boolean isCleanStart() {
        return this.isCleanStart;
    }

    public int keepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public MqttProperties properties() {
        return this.properties;
    }

    public String toString() {
        return "MqttConnectVariableHeader[name=" + this.name + ", version=" + this.version + ", hasUsername=" + this.hasUsername + ", hasPassword=" + this.hasPassword + ", isWillRetain=" + this.isWillRetain + ", isWillFlag=" + this.isWillFlag + ", isCleanStart=" + this.isCleanStart + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ']';
    }
}

