/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.header;

import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdVariableHeader;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttPubReplyMessageVariableHeader
extends MqttMessageIdVariableHeader {
    public static final byte REASON_CODE_OK = 0;
    private final byte reasonCode;
    private final MqttProperties properties;

    public MqttPubReplyMessageVariableHeader(int messageId, byte reasonCode, MqttProperties properties) {
        super(messageId);
        if (messageId < 1 || messageId > 65535) {
            throw new IllegalArgumentException("messageId: " + messageId + " (expected: 1 ~ 65535)");
        }
        this.reasonCode = reasonCode;
        this.properties = MqttProperties.withEmptyDefaults(properties);
    }

    public byte reasonCode() {
        return this.reasonCode;
    }

    public MqttProperties properties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttPubReplyMessageVariableHeader[messageId=" + this.messageId() + ", reasonCode=" + this.reasonCode + ", properties=" + this.properties + ']';
    }
}

