/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.payload;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttConnectPayload {
    private final String clientIdentifier;
    private final MqttProperties willProperties;
    private final String willTopic;
    private final byte[] willMessage;
    private final String username;
    private final byte[] password;

    public MqttConnectPayload(String clientIdentifier, String willTopic, byte[] willMessage, String username, byte[] password) {
        this(clientIdentifier, MqttProperties.NO_PROPERTIES, willTopic, willMessage, username, password);
    }

    public MqttConnectPayload(String clientIdentifier, MqttProperties willProperties, String willTopic, byte[] willMessage, String username, byte[] password) {
        this.clientIdentifier = clientIdentifier;
        this.willProperties = MqttProperties.withEmptyDefaults(willProperties);
        this.willTopic = willTopic;
        this.willMessage = willMessage;
        this.username = username;
        this.password = password;
    }

    public String clientIdentifier() {
        return this.clientIdentifier;
    }

    public MqttProperties willProperties() {
        return this.willProperties;
    }

    public String willTopic() {
        return this.willTopic;
    }

    public byte[] willMessageInBytes() {
        return this.willMessage;
    }

    public String username() {
        return this.username;
    }

    public byte[] passwordInBytes() {
        return this.password;
    }

    public String password() {
        return this.password == null ? null : new String(this.password, StandardCharsets.UTF_8);
    }

    public String toString() {
        return "MqttConnectPayload[clientIdentifier=" + this.clientIdentifier + ", willTopic=" + this.willTopic + ", willMessage=" + Arrays.toString(this.willMessage) + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ']';
    }
}

