/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.BooleanProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttConnectProperties {
    private final MqttProperties properties;

    public MqttConnectProperties() {
        this(new MqttProperties());
    }

    public MqttConnectProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttConnectProperties setSessionExpiryInterval(int sessionExpiryInterval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.SESSION_EXPIRY_INTERVAL, (Integer)sessionExpiryInterval));
        return this;
    }

    public MqttConnectProperties setAuthenticationMethod(String authenticationMethod) {
        this.properties.add(new StringProperty(MqttPropertyType.AUTHENTICATION_METHOD, authenticationMethod));
        return this;
    }

    public MqttConnectProperties setAuthenticationData(byte[] authenticationData) {
        this.properties.add(new BinaryProperty(MqttPropertyType.AUTHENTICATION_DATA, authenticationData));
        return this;
    }

    public MqttConnectProperties setRequestProblemInformation(boolean requestProblemInformation) {
        this.properties.add(new BooleanProperty(MqttPropertyType.REQUEST_PROBLEM_INFORMATION, requestProblemInformation));
        return this;
    }

    public MqttConnectProperties setRequestResponseInformation(boolean requestResponseInformation) {
        this.properties.add(new BooleanProperty(MqttPropertyType.REQUEST_RESPONSE_INFORMATION, requestResponseInformation));
        return this;
    }

    public MqttConnectProperties setReceiveMaximum(int receiveMaximum) {
        this.properties.add(new IntegerProperty(MqttPropertyType.RECEIVE_MAXIMUM, (Integer)receiveMaximum));
        return this;
    }

    public MqttConnectProperties setTopicAliasMaximum(int topicAliasMaximum) {
        this.properties.add(new IntegerProperty(MqttPropertyType.TOPIC_ALIAS_MAXIMUM, (Integer)topicAliasMaximum));
        return this;
    }

    public MqttConnectProperties setMaximumPacketSize(int maximumPacketSize) {
        this.properties.add(new IntegerProperty(MqttPropertyType.MAXIMUM_PACKET_SIZE, (Integer)maximumPacketSize));
        return this;
    }

    public MqttConnectProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttConnectProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

