/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttPublishProperties {
    private final MqttProperties properties;

    public MqttPublishProperties() {
        this(new MqttProperties());
    }

    public MqttPublishProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttPublishProperties setPayloadFormatIndicator(int indicator) {
        this.properties.add(new IntegerProperty(MqttPropertyType.PAYLOAD_FORMAT_INDICATOR, (Integer)indicator));
        return this;
    }

    public MqttPublishProperties setMessageExpiryInterval(int interval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.MESSAGE_EXPIRY_INTERVAL, (Integer)interval));
        return this;
    }

    public MqttPublishProperties setCorrelationData(byte[] correlationData) {
        this.properties.add(new BinaryProperty(MqttPropertyType.CORRELATION_DATA, correlationData));
        return this;
    }

    public MqttPublishProperties setContentType(String contentType) {
        this.properties.add(new StringProperty(MqttPropertyType.CONTENT_TYPE, contentType));
        return this;
    }

    public MqttPublishProperties setResponseTopic(String responseTopic) {
        this.properties.add(new StringProperty(MqttPropertyType.RESPONSE_TOPIC, responseTopic));
        return this;
    }

    public MqttPublishProperties setSubscriptionIdentifier(int subscriptionIdentifier) {
        this.properties.add(new IntegerProperty(MqttPropertyType.SUBSCRIPTION_IDENTIFIER, (Integer)subscriptionIdentifier));
        return this;
    }

    public MqttPublishProperties setTopicAlias(int topicAlias) {
        this.properties.add(new IntegerProperty(MqttPropertyType.TOPIC_ALIAS, (Integer)topicAlias));
        return this;
    }

    public MqttPublishProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttPublishProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

