/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.properties;

import org.dromara.mica.mqtt.codec.properties.BinaryProperty;
import org.dromara.mica.mqtt.codec.properties.IntegerProperty;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;
import org.dromara.mica.mqtt.codec.properties.MqttPropertyType;
import org.dromara.mica.mqtt.codec.properties.StringProperty;
import org.dromara.mica.mqtt.codec.properties.UserProperty;

public class MqttWillPublishProperties {
    private final MqttProperties properties;

    public MqttWillPublishProperties() {
        this(new MqttProperties());
    }

    public MqttWillPublishProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public MqttWillPublishProperties setPayloadFormatIndicator(int indicator) {
        this.properties.add(new IntegerProperty(MqttPropertyType.PAYLOAD_FORMAT_INDICATOR, (Integer)indicator));
        return this;
    }

    public MqttWillPublishProperties setMessageExpiryInterval(int interval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.MESSAGE_EXPIRY_INTERVAL, (Integer)interval));
        return this;
    }

    public MqttWillPublishProperties setCorrelationData(byte[] correlationData) {
        this.properties.add(new BinaryProperty(MqttPropertyType.CORRELATION_DATA, correlationData));
        return this;
    }

    public MqttWillPublishProperties setContentType(String contentType) {
        this.properties.add(new StringProperty(MqttPropertyType.CONTENT_TYPE, contentType));
        return this;
    }

    public MqttWillPublishProperties setResponseTopic(String responseTopic) {
        this.properties.add(new StringProperty(MqttPropertyType.RESPONSE_TOPIC, responseTopic));
        return this;
    }

    public MqttWillPublishProperties setWillDelayInterval(int interval) {
        this.properties.add(new IntegerProperty(MqttPropertyType.WILL_DELAY_INTERVAL, (Integer)interval));
        return this;
    }

    public MqttWillPublishProperties addUserProperty(UserProperty userProperty) {
        this.properties.add(userProperty);
        return this;
    }

    public MqttWillPublishProperties addUserProperty(String key, String value) {
        this.addUserProperty(new UserProperty(key, value));
        return this;
    }
}

