/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.common;

import java.util.Objects;
import org.dromara.mica.mqtt.codec.MqttMessage;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.core.common.RetryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.timer.TimerTaskService;

public final class MqttPendingPublish {
    private static final Logger logger = LoggerFactory.getLogger(MqttPendingPublish.class);
    private final MqttPublishMessage message;
    private final MqttQoS qos;
    private final RetryProcessor<MqttPublishMessage> pubRetryProcessor = new RetryProcessor();
    private final RetryProcessor<MqttMessage> pubRelRetryProcessor = new RetryProcessor();

    public MqttPendingPublish(MqttPublishMessage message, MqttQoS qos) {
        this.message = message;
        this.qos = qos;
        this.pubRetryProcessor.setOriginalMessage(message);
    }

    public MqttPublishMessage getMessage() {
        return this.message;
    }

    public MqttQoS getQos() {
        return this.qos;
    }

    public void startPublishRetransmissionTimer(TimerTaskService taskService, ChannelContext context) {
        this.pubRetryProcessor.setHandle((fixedHeader, originalMessage) -> {
            MqttPublishMessage publishMessage = new MqttPublishMessage(fixedHeader, originalMessage.variableHeader(), this.message.payload());
            boolean result = Tio.send((ChannelContext)context, (Packet)publishMessage);
            if (context.isServer()) {
                logger.info("retry send Publish msg clientId:{} qos:{} result:{}", new Object[]{context.getBsId(), this.qos, result});
            } else {
                logger.info("retry send Publish msg qos:{} result:{}", (Object)this.qos, (Object)result);
            }
        });
        this.pubRetryProcessor.start(taskService);
    }

    public void onPubAckReceived() {
        this.pubRetryProcessor.stop();
    }

    public void setPubRelMessage(MqttMessage pubRelMessage) {
        this.pubRelRetryProcessor.setOriginalMessage(pubRelMessage);
    }

    public void startPubRelRetransmissionTimer(TimerTaskService taskService, ChannelContext context) {
        this.pubRelRetryProcessor.setHandle((fixedHeader, originalMessage) -> {
            boolean result = Tio.send((ChannelContext)context, (Packet)new MqttMessage(fixedHeader, originalMessage.variableHeader()));
            if (context.isServer()) {
                logger.info("retry send PubRel msg clientId:{} qos:{} result:{}", new Object[]{context.getBsId(), this.qos, result});
            } else {
                logger.info("retry send PubRel msg qos:{} result:{}", (Object)this.qos, (Object)result);
            }
        });
        this.pubRelRetryProcessor.start(taskService);
    }

    public void onPubCompReceived() {
        this.pubRelRetryProcessor.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttPendingPublish that = (MqttPendingPublish)o;
        return Objects.equals(this.message, that.message) && this.qos == that.qos;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.qos);
    }
}

