/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dromara.mica.mqtt.codec.MqttCodecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.mica.Pair;
import org.tio.utils.mica.StrTemplateParser;

public final class TopicUtil {
    private static final Logger logger = LoggerFactory.getLogger(TopicUtil.class);
    public static final String TOPIC_LAYER = "/";
    public static final String TOPIC_WILDCARDS_ONE = "+";
    public static final String TOPIC_WILDCARDS_MORE = "#";

    public static void validateTopicFilter(List<String> topicFilterList) {
        for (String topicFilter : topicFilterList) {
            TopicUtil.validateTopicFilter(topicFilter);
        }
    }

    public static void validateTopicFilter(String topicFilter) throws IllegalArgumentException {
        if (StrUtil.isEmpty((CharSequence)topicFilter)) {
            throw new IllegalArgumentException("TopicFilter is empty:" + topicFilter);
        }
        char[] topicFilterChars = topicFilter.toCharArray();
        int topicFilterLength = topicFilterChars.length;
        int topicFilterIdxEnd = topicFilterLength - 1;
        for (int i = 0; i < topicFilterLength; ++i) {
            char ch = topicFilterChars[i];
            if (Character.isWhitespace(ch)) {
                logger.warn("\u6ce8\u610f\uff1atopic:[{}] \u4e2d\u5305\u542b\u7a7a\u767d\u5b57\u7b26\u4e32:[{}]\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e", (Object)topicFilter, (Object)Character.valueOf(ch));
                continue;
            }
            if (!(ch == '#' ? i < topicFilterIdxEnd : ch == '+' && (i > 0 && topicFilterChars[i - 1] != '/' || i < topicFilterIdxEnd && topicFilterChars[i + 1] != '/'))) continue;
            throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
        }
    }

    public static void validateTopicName(String topicName) throws IllegalArgumentException {
        if (MqttCodecUtil.isTopicFilter((String)topicName)) {
            throw new IllegalArgumentException("Topic has wildcards char [+] or [#], topicName:" + topicName);
        }
    }

    public static Pair<String, Integer> retainTopicName(String topicName) {
        if (topicName.startsWith("$retain/")) {
            return TopicUtil.getRetainTopicPair(topicName);
        }
        return new Pair((Object)topicName, (Object)0);
    }

    private static Pair<String, Integer> getRetainTopicPair(String topicName) {
        int time;
        int timeIndexBegin = 8;
        int nextLayer = topicName.indexOf(47, timeIndexBegin);
        if (nextLayer == -1) {
            return new Pair((Object)topicName, (Object)-1);
        }
        try {
            time = Integer.parseInt(topicName.substring(timeIndexBegin, nextLayer));
        }
        catch (NumberFormatException e) {
            time = -1;
        }
        String retainTopic = topicName.substring(nextLayer + 1);
        if (retainTopic.isEmpty()) {
            return new Pair((Object)topicName, (Object)-1);
        }
        return new Pair((Object)retainTopic, (Object)time);
    }

    public static boolean match(String topicFilter, String topicName) {
        char[] topicFilterChars = topicFilter.toCharArray();
        char[] topicNameChars = topicName.toCharArray();
        int topicFilterLength = topicFilterChars.length;
        int topicNameLength = topicNameChars.length;
        int topicFilterIdxEnd = topicFilterLength - 1;
        int topicNameIdxEnd = topicNameLength - 1;
        boolean inLayerWildcard = false;
        int wildcardCharLen = 0;
        block0: for (int i = 0; i < topicFilterLength; ++i) {
            int topicNameIdx;
            char ch = topicFilterChars[i];
            if (ch == '#') {
                if (i < topicFilterIdxEnd) {
                    throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
                }
                return true;
            }
            if (ch == '+') {
                if (i > 0 && topicFilterChars[i - 1] != '/' || i < topicFilterIdxEnd && topicFilterChars[i + 1] != '/') {
                    throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
                }
                topicNameIdx = i + wildcardCharLen;
                if (i == topicFilterIdxEnd && topicNameLength > topicNameIdx) {
                    for (int j = topicNameIdx; j < topicNameLength; ++j) {
                        if (topicNameChars[j] != '/') continue;
                        return false;
                    }
                    return true;
                }
                inLayerWildcard = true;
            } else if (ch == '/') {
                int next;
                if (inLayerWildcard) {
                    inLayerWildcard = false;
                }
                if (topicFilterLength > (next = i + 1) && topicFilterChars[next] == '#' && topicNameLength < next) {
                    return true;
                }
            }
            if (topicNameIdxEnd < i) {
                return false;
            }
            if (inLayerWildcard) {
                for (int j = i + wildcardCharLen; j < topicNameLength; ++j) {
                    if (topicNameChars[j] == '/') {
                        --wildcardCharLen;
                        continue block0;
                    }
                    ++wildcardCharLen;
                }
            }
            if ((topicNameIdx = i + wildcardCharLen) > topicNameIdxEnd) {
                return false;
            }
            if (ch == topicNameChars[topicNameIdx]) continue;
            return false;
        }
        return topicFilterLength + wildcardCharLen + 1 > topicNameLength;
    }

    public static String getTopicFilter(String topicTemplate) {
        StringTokenizer tokenizer = new StringTokenizer(topicTemplate, TOPIC_LAYER, true);
        StringBuilder topicFilterBuilder = new StringBuilder(topicTemplate.length());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (TOPIC_LAYER.equals(token)) {
                topicFilterBuilder.append(token);
                continue;
            }
            if (TopicUtil.hasVariable(token)) {
                topicFilterBuilder.append('+');
                continue;
            }
            topicFilterBuilder.append(token);
        }
        return topicFilterBuilder.toString();
    }

    public static boolean hasVariable(String input) {
        if (StrUtil.isBlank((CharSequence)input)) {
            return false;
        }
        int startIndex = input.indexOf("${");
        if (startIndex == -1) {
            return false;
        }
        int endIndex = input.indexOf(125, startIndex);
        return endIndex != -1 && endIndex > startIndex + 2;
    }

    public static String resolveTopic(String topicTemplate, Object payload) {
        int end;
        int start;
        if (payload == null) {
            return topicTemplate;
        }
        StringBuilder sb = new StringBuilder((int)((double)topicTemplate.length() * 1.5));
        int cursor = 0;
        while ((start = topicTemplate.indexOf("${", cursor)) != -1 && (end = topicTemplate.indexOf(125, start)) != -1) {
            sb.append(topicTemplate, cursor, start);
            String fieldName = topicTemplate.substring(start + 2, end);
            Object value = TopicUtil.getFieldValue(payload, fieldName);
            sb.append(value == null ? "" : value);
            cursor = end + 1;
        }
        if (cursor == 0) {
            return topicTemplate;
        }
        sb.append(topicTemplate.substring(cursor));
        return sb.toString();
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to resolve field: " + fieldName + " from payload object", e);
        }
    }

    public static String[] getTopicParts(String topic) {
        ArrayList<String> tokenList = new ArrayList<String>(10);
        char[] topicChars = topic.toCharArray();
        int topicLength = topicChars.length;
        int topicIdxEnd = topicLength - 1;
        int prev = 0;
        for (int i = 0; i < topicLength; ++i) {
            char ch = topicChars[i];
            if ('/' == ch) {
                if (i == 0) {
                    tokenList.add(TOPIC_LAYER);
                    ++prev;
                    continue;
                }
                tokenList.add(new String(topicChars, prev, i - prev));
                prev = i;
                ++prev;
                if (i != topicIdxEnd) continue;
                tokenList.add(TOPIC_LAYER);
                continue;
            }
            if (i != topicIdxEnd) continue;
            tokenList.add(new String(topicChars, prev, topicLength - prev));
        }
        return tokenList.toArray(new String[0]);
    }

    public static Map<String, String> getTopicVars(String topicTemplate, String topic) {
        StrTemplateParser templateParser = new StrTemplateParser(topicTemplate);
        return templateParser.getVariables(topic);
    }
}

