/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.config;

import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.server.solon.config.DataSize;
import org.dromara.mica.mqtt.server.solon.config.MqttServerProperties;
import org.dromara.mica.mqtt.server.solon.event.SolonEventMqttConnectStatusListener;
import org.dromara.mica.mqtt.server.solon.event.SolonEventMqttMessageListener;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;

@Configuration
public class MqttServerConfiguration {
    @Bean
    @Condition(onMissingBean=IMqttConnectStatusListener.class)
    public IMqttConnectStatusListener connectStatusListener() {
        return new SolonEventMqttConnectStatusListener();
    }

    @Bean
    @Condition(onMissingBean=IMqttMessageListener.class)
    public IMqttMessageListener messageListener() {
        return new SolonEventMqttMessageListener();
    }

    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties) {
        MqttServerProperties.Ssl ssl;
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize((int)DataSize.parse(properties.getReadBufferSize()).getBytes()).maxBytesInMessage((int)DataSize.parse(properties.getMaxBytesInMessage()).getBytes()).bufferAllocator(properties.getBufferAllocator()).maxClientIdLength(properties.getMaxClientIdLength()).webPort(properties.getWebPort()).websocketEnable(properties.isWebsocketEnable()).httpEnable(properties.isHttpEnable()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable()).proxyProtocolEnable(properties.isProxyProtocolOn());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        MqttServerProperties.HttpBasicAuth httpBasicAuth = properties.getHttpBasicAuth();
        if (serverCreator.isHttpEnable() && httpBasicAuth.isEnable()) {
            serverCreator.httpBasicAuth(httpBasicAuth.getUsername(), httpBasicAuth.getPassword());
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            serverCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth());
        }
        return serverCreator;
    }
}

