/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.event;

import java.util.concurrent.TimeUnit;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.server.solon.event.MqttClientOfflineEvent;
import org.dromara.mica.mqtt.server.solon.event.MqttClientOnlineEvent;
import org.noear.solon.core.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;

public class SolonEventMqttConnectStatusListener
implements IMqttConnectStatusListener {
    private static final Logger log = LoggerFactory.getLogger(SolonEventMqttConnectStatusListener.class);

    public void online(ChannelContext context, String clientId, String username) {
        log.info("Mqtt clientId:{} username:{} online.", (Object)clientId, (Object)username);
        MqttClientOnlineEvent onlineEvent = new MqttClientOnlineEvent();
        onlineEvent.setClientId(clientId);
        onlineEvent.setUsername(username);
        Node clientNode = context.getClientNode();
        onlineEvent.setIpAddress(clientNode.getIp());
        onlineEvent.setPort(clientNode.getPort());
        long keepalive = context.heartbeatTimeout == null ? 60L : TimeUnit.MILLISECONDS.toSeconds(context.heartbeatTimeout);
        onlineEvent.setKeepalive(keepalive);
        onlineEvent.setTs(context.stat.timeCreated);
        EventBus.publish((Object)onlineEvent);
    }

    public void offline(ChannelContext context, String clientId, String username, String reason) {
        log.info("Mqtt clientId:{} username:{} offline reason:{}.", new Object[]{clientId, username, reason});
        MqttClientOfflineEvent offlineEvent = new MqttClientOfflineEvent();
        offlineEvent.setClientId(clientId);
        offlineEvent.setUsername(username);
        offlineEvent.setReason(reason);
        offlineEvent.setTs(context.stat.timeClosed);
        EventBus.publish((Object)offlineEvent);
    }
}

