/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.config;

import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.server.solon.config.DataSize;
import org.dromara.mica.mqtt.server.solon.config.MqttServerProperties;
import org.dromara.mica.mqtt.server.solon.event.SolonEventMqttConnectStatusListener;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.tio.core.Node;

@Configuration
public class MqttServerConfiguration {
    @Bean
    @Condition(onMissingBean=IMqttConnectStatusListener.class)
    public IMqttConnectStatusListener connectStatusListener() {
        return new SolonEventMqttConnectStatusListener();
    }

    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties) {
        MqttServerProperties.HttpListener httpListener;
        MqttServerProperties.Listener wsListener;
        MqttServerProperties.SslListener mqttSslListener;
        MqttServerProperties.Listener mqttListener;
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize((int)DataSize.parse(properties.getReadBufferSize()).getBytes()).maxBytesInMessage((int)DataSize.parse(properties.getMaxBytesInMessage()).getBytes()).maxClientIdLength(properties.getMaxClientIdLength()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable()).proxyProtocolEnable(properties.isProxyProtocolOn());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        if ((mqttListener = properties.getMqttListener()).isEnable()) {
            serverCreator.enableMqtt(builder -> builder.serverNode(mqttListener.getServerNode()).build());
        }
        if ((mqttSslListener = properties.getMqttSslListener()).isEnable()) {
            MqttServerProperties.Ssl ssl = mqttSslListener.getSsl();
            serverCreator.enableMqttSsl(sslBuilder -> sslBuilder.serverNode(mqttSslListener.getServerNode()).useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth()).build());
        }
        if ((wsListener = properties.getWsListener()).isEnable()) {
            serverCreator.enableMqttWs(builder -> builder.serverNode(wsListener.getServerNode()).build());
        }
        MqttServerProperties.SslListener wssListener = properties.getWssListener();
        if (mqttSslListener.isEnable()) {
            MqttServerProperties.Ssl ssl = wssListener.getSsl();
            serverCreator.enableMqttWss(sslBuilder -> sslBuilder.serverNode(wssListener.getServerNode()).useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth()).build());
        }
        if ((httpListener = properties.getHttpListener()).isEnable()) {
            Node serverNode = httpListener.getServerNode();
            MqttServerProperties.HttpBasicAuth basicAuth = httpListener.getBasicAuth();
            MqttServerProperties.McpServer mcpServer = httpListener.getMcpServer();
            MqttServerProperties.HttpSsl ssl = httpListener.getSsl();
            serverCreator.enableMqttHttpApi(builder -> {
                builder.serverNode(serverNode);
                if (basicAuth.isEnable()) {
                    builder.basicAuth(basicAuth.getUsername(), basicAuth.getPassword());
                }
                if (mcpServer.isEnable()) {
                    builder.mcpServer(mcpServer.getSseEndpoint(), mcpServer.getMessageEndpoint());
                }
                if (ssl.isEnable()) {
                    builder.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass(), ssl.getClientAuth());
                }
                return builder.build();
            });
        }
        return serverCreator;
    }
}

