/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.config;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.server.ServerGroupStat;
import org.tio.server.TioServerConfig;

public class MqttServerMetrics {
    private static final Logger log = LoggerFactory.getLogger(MqttServerMetrics.class);
    public static final String MQTT_METRIC_NAME_PREFIX = "mqtt";
    private static final String MQTT_CONNECTIONS_ACCEPTED = "mqtt.connections.accepted";
    private static final String MQTT_CONNECTIONS_SIZE = "mqtt.connections.size";
    private static final String MQTT_CONNECTIONS_CLOSED = "mqtt.connections.closed";
    private static final String MQTT_MESSAGES_HANDLED_PACKETS = "mqtt.messages.handled.packets";
    private static final String MQTT_MESSAGES_HANDLED_BYTES = "mqtt.messages.handled.bytes";
    private static final String MQTT_MESSAGES_RECEIVED_PACKETS = "mqtt.messages.received.packets";
    private static final String MQTT_MESSAGES_RECEIVED_BYTES = "mqtt.messages.received.bytes";
    private static final String MQTT_MESSAGES_SEND_PACKETS = "mqtt.messages.send.packets";
    private static final String MQTT_MESSAGES_SEND_BYTES = "mqtt.messages.send.bytes";
    private final Iterable<Tag> tags;

    public MqttServerMetrics() {
        this(Collections.emptyList());
    }

    public void bindTo(MeterRegistry meterRegistry, TioServerConfig serverConfig) {
        Gauge.builder((String)MQTT_CONNECTIONS_ACCEPTED, (Object)serverConfig, config -> ((ServerGroupStat)config.getGroupStat()).accepted.sum()).description("Mqtt server connections accepted").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_CONNECTIONS_SIZE, (Object)serverConfig, config -> Tio.getAll((TioConfig)config).size()).description("Mqtt server connections size").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_CONNECTIONS_CLOSED, (Object)serverConfig, config -> config.getGroupStat().getClosed().sum()).description("Mqtt server connections closed").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_HANDLED_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getHandledPackets().sum()).description("Mqtt server handled packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_HANDLED_BYTES, (Object)serverConfig, config -> config.getGroupStat().getHandledBytes().sum()).description("Mqtt server handled bytes").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_RECEIVED_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getReceivedPackets().sum()).description("Mqtt server received packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_RECEIVED_BYTES, (Object)serverConfig, config -> config.getGroupStat().getReceivedBytes().sum()).description("Mqtt server received bytes").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_SEND_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getSentPackets().sum()).description("Mqtt server send packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_SEND_BYTES, (Object)serverConfig, config -> config.getGroupStat().getSentPackets().sum()).description("Mqtt server send bytes").tags(this.tags).register(meterRegistry);
    }

    public MqttServerMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }
}

