/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.integration;

import java.util.Objects;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.MqttServerCustomizer;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerPublishPermission;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerUniqueIdService;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.event.IMqttSessionListener;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.dromara.mica.mqtt.server.solon.MqttServerTemplate;
import org.dromara.mica.mqtt.server.solon.config.MqttServerConfiguration;
import org.dromara.mica.mqtt.server.solon.config.MqttServerMetricsConfiguration;
import org.dromara.mica.mqtt.server.solon.config.MqttServerProperties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttServerPluginImpl
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MqttServerPluginImpl.class);
    private volatile boolean running = false;
    private AppContext context;

    public void start(AppContext context) throws Throwable {
        this.context = context;
        context.lifecycle(-9, () -> {
            context.beanMake(MqttServerProperties.class);
            context.beanMake(MqttServerConfiguration.class);
            MqttServerProperties properties = (MqttServerProperties)context.getBean(MqttServerProperties.class);
            MqttServerCreator serverCreator = (MqttServerCreator)context.getBean(MqttServerCreator.class);
            IMqttServerAuthHandler authHandlerImpl = (IMqttServerAuthHandler)context.getBean(IMqttServerAuthHandler.class);
            IMqttServerUniqueIdService uniqueIdService = (IMqttServerUniqueIdService)context.getBean(IMqttServerUniqueIdService.class);
            IMqttServerSubscribeValidator subscribeValidator = (IMqttServerSubscribeValidator)context.getBean(IMqttServerSubscribeValidator.class);
            IMqttServerPublishPermission publishPermission = (IMqttServerPublishPermission)context.getBean(IMqttServerPublishPermission.class);
            IMqttMessageDispatcher messageDispatcher = (IMqttMessageDispatcher)context.getBean(IMqttMessageDispatcher.class);
            IMqttMessageStore messageStore = (IMqttMessageStore)context.getBean(IMqttMessageStore.class);
            IMqttSessionManager sessionManager = (IMqttSessionManager)context.getBean(IMqttSessionManager.class);
            IMqttSessionListener sessionListener = (IMqttSessionListener)context.getBean(IMqttSessionListener.class);
            IMqttMessageListener messageListener = (IMqttMessageListener)context.getBean(IMqttMessageListener.class);
            IMqttConnectStatusListener connectStatusListener = (IMqttConnectStatusListener)context.getBean(IMqttConnectStatusListener.class);
            IMqttMessageInterceptor messageInterceptor = (IMqttMessageInterceptor)context.getBean(IMqttMessageInterceptor.class);
            MqttServerCustomizer customizers = (MqttServerCustomizer)context.getBean(MqttServerCustomizer.class);
            serverCreator.messageListener(messageListener);
            MqttServerProperties.MqttAuth mqttAuth = properties.getAuth();
            if (Objects.isNull(authHandlerImpl)) {
                DefaultMqttServerAuthHandler authHandler = mqttAuth.isEnable() ? new DefaultMqttServerAuthHandler(mqttAuth.getUsername(), mqttAuth.getPassword()) : null;
                serverCreator.authHandler((IMqttServerAuthHandler)authHandler);
            } else {
                serverCreator.authHandler(authHandlerImpl);
            }
            if (Objects.nonNull(uniqueIdService)) {
                serverCreator.uniqueIdService(uniqueIdService);
            }
            if (Objects.nonNull(subscribeValidator)) {
                serverCreator.subscribeValidator(subscribeValidator);
            }
            if (Objects.nonNull(publishPermission)) {
                serverCreator.publishPermission(publishPermission);
            }
            if (Objects.nonNull(messageDispatcher)) {
                serverCreator.messageDispatcher(messageDispatcher);
            }
            if (Objects.nonNull(messageStore)) {
                serverCreator.messageStore(messageStore);
            }
            if (Objects.nonNull(sessionManager)) {
                serverCreator.sessionManager(sessionManager);
            }
            if (Objects.nonNull(sessionListener)) {
                serverCreator.sessionListener(sessionListener);
            }
            if (Objects.nonNull(connectStatusListener)) {
                serverCreator.connectStatusListener(connectStatusListener);
            }
            if (Objects.nonNull(messageInterceptor)) {
                serverCreator.addInterceptor(messageInterceptor);
            }
            if (Objects.nonNull(customizers)) {
                customizers.customize(serverCreator);
            }
            MqttServer mqttServer = serverCreator.build();
            MqttServerTemplate mqttServerTemplate = new MqttServerTemplate(mqttServer);
            context.wrapAndPut(MqttServerTemplate.class, (Object)mqttServerTemplate);
            context.beanMake(MqttServerMetricsConfiguration.class);
            if (properties.isEnabled() && !this.running) {
                this.running = mqttServerTemplate.getMqttServer().start();
                log.info("mqtt server start...");
            }
        });
    }

    public void stop() {
        if (this.running) {
            MqttServerTemplate mqttServerTemplate = (MqttServerTemplate)this.context.getBean(MqttServerTemplate.class);
            mqttServerTemplate.getMqttServer().stop();
            log.info("mqtt server stop...");
        }
    }
}

