/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.config;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tio.utils.hutool.StrUtil;

class DataSize {
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private final long bytes;

    public static DataSize ofBytes(long bytes) {
        return new DataSize(bytes);
    }

    public static DataSize ofKilobytes(long kilobytes) {
        return new DataSize(Math.multiplyExact(kilobytes, 1024L));
    }

    public static DataSize ofMegabytes(long megabytes) {
        return new DataSize(Math.multiplyExact(megabytes, 0x100000L));
    }

    public static DataSize ofGigabytes(long gigabytes) {
        return new DataSize(Math.multiplyExact(gigabytes, 0x40000000L));
    }

    public static DataSize ofTerabytes(long terabytes) {
        return new DataSize(Math.multiplyExact(terabytes, 0x10000000000L));
    }

    public static DataSize of(long amount, DataUnit unit) {
        Objects.requireNonNull(unit, "Unit must not be null");
        return new DataSize(Math.multiplyExact(amount, unit.getSize().getBytes()));
    }

    public static DataSize parse(String text) {
        Objects.requireNonNull(text, "Text must not be null");
        try {
            Matcher matcher = DataSizeUtils.PATTERN.matcher(text.trim());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid data size: " + text);
            }
            DataUnit unit = DataSizeUtils.determineDataUnit(matcher.group(2));
            long amount = Long.parseLong(matcher.group(1));
            return DataSize.of(amount, unit);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("'" + text + "' is not a valid data size", ex);
        }
    }

    public long getBytes() {
        return this.bytes;
    }

    public DataSize(long bytes) {
        this.bytes = bytes;
    }

    public static enum DataUnit {
        BYTES("B", DataSize.ofBytes(1L)),
        KILOBYTES("KB", DataSize.ofKilobytes(1L)),
        MEGABYTES("MB", DataSize.ofMegabytes(1L)),
        GIGABYTES("GB", DataSize.ofGigabytes(1L)),
        TERABYTES("TB", DataSize.ofTerabytes(1L));

        private final String suffix;
        private final DataSize size;

        public static DataUnit fromSuffix(String suffix) {
            for (DataUnit candidate : DataUnit.values()) {
                if (!candidate.suffix.equals(suffix)) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Unknown data unit suffix '" + suffix + "'");
        }

        public String getSuffix() {
            return this.suffix;
        }

        public DataSize getSize() {
            return this.size;
        }

        private DataUnit(String suffix, DataSize size) {
            this.suffix = suffix;
            this.size = size;
        }
    }

    private static class DataSizeUtils {
        private static final Pattern PATTERN = Pattern.compile("^([+\\-]?\\d+)([a-zA-Z]{0,2})$");

        private DataSizeUtils() {
        }

        private static DataUnit determineDataUnit(String suffix) {
            return StrUtil.isNotBlank((CharSequence)suffix) ? DataUnit.fromSuffix(suffix) : DataUnit.BYTES;
        }
    }
}

