/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.integration;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.dromara.mica.mqtt.codec.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.tio.core.ChannelContext;
import org.tio.utils.mica.ExceptionUtils;

class MqttServerFunctionListener
implements IMqttFunctionMessageListener {
    private final Object bean;
    private final Method method;
    private final MqttDeserializer deserializer;

    public void onMessage(ChannelContext context, String clientId, String topic, MqttQoS qoS, MqttPublishMessage message) {
        Object[] methodParameters = this.getMethodParameters(this.method, context, topic, message, message.payload());
        try {
            this.method.invoke(this.bean, methodParameters);
        }
        catch (Throwable e) {
            throw ExceptionUtils.unchecked((Throwable)e);
        }
    }

    private Object[] getMethodParameters(Method method, ChannelContext context, String topic, MqttPublishMessage message, byte[] payload) {
        int paramCount = method.getParameterCount();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] parameters = new Object[paramCount];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parameters[i] = parameterType == ChannelContext.class ? context : (parameterType == String.class ? topic : (parameterType == MqttPublishMessage.class ? message : (parameterType == byte[].class ? (Object)payload : (parameterType == ByteBuffer.class ? ByteBuffer.wrap(payload) : this.deserializer.deserialize(payload, parameterType)))));
        }
        return parameters;
    }

    public MqttServerFunctionListener(Object bean, Method method, MqttDeserializer deserializer) {
        this.bean = bean;
        this.method = method;
        this.deserializer = deserializer;
    }
}

