/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.config;

import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.tio.core.Node;
import org.tio.core.ssl.ClientAuth;

@Inject(value="${mqtt.server}", required=false)
@Configuration
public class MqttServerProperties {
    public static final String PREFIX = "mqtt.server";
    private boolean enabled = true;
    private String name = "Mica-Mqtt-Server";
    private MqttAuth auth = new MqttAuth();
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private String readBufferSize = "8KB";
    private String maxBytesInMessage = "10MB";
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private String nodeName;
    private boolean statEnable = true;
    private boolean proxyProtocolOn = false;
    private Listener mqttListener = new Listener();
    private SslListener mqttSslListener = new SslListener();
    private Listener wsListener = new Listener();
    private SslListener wssListener = new SslListener();
    private HttpListener httpListener = new HttpListener();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public MqttAuth getAuth() {
        return this.auth;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public String getReadBufferSize() {
        return this.readBufferSize;
    }

    public String getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public boolean isProxyProtocolOn() {
        return this.proxyProtocolOn;
    }

    public Listener getMqttListener() {
        return this.mqttListener;
    }

    public SslListener getMqttSslListener() {
        return this.mqttSslListener;
    }

    public Listener getWsListener() {
        return this.wsListener;
    }

    public SslListener getWssListener() {
        return this.wssListener;
    }

    public HttpListener getHttpListener() {
        return this.httpListener;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuth(MqttAuth auth) {
        this.auth = auth;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setKeepaliveBackoff(float keepaliveBackoff) {
        this.keepaliveBackoff = keepaliveBackoff;
    }

    public void setReadBufferSize(String readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(String maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public void setProxyProtocolOn(boolean proxyProtocolOn) {
        this.proxyProtocolOn = proxyProtocolOn;
    }

    public void setMqttListener(Listener mqttListener) {
        this.mqttListener = mqttListener;
    }

    public void setMqttSslListener(SslListener mqttSslListener) {
        this.mqttSslListener = mqttSslListener;
    }

    public void setWsListener(Listener wsListener) {
        this.wsListener = wsListener;
    }

    public void setWssListener(SslListener wssListener) {
        this.wssListener = wssListener;
    }

    public void setHttpListener(HttpListener httpListener) {
        this.httpListener = httpListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttServerProperties)) {
            return false;
        }
        MqttServerProperties other = (MqttServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Float.compare(this.getKeepaliveBackoff(), other.getKeepaliveBackoff()) != 0) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.getMaxClientIdLength() != other.getMaxClientIdLength()) {
            return false;
        }
        if (this.isStatEnable() != other.isStatEnable()) {
            return false;
        }
        if (this.isProxyProtocolOn() != other.isProxyProtocolOn()) {
            return false;
        }
        Long this$heartbeatTimeout = this.getHeartbeatTimeout();
        Long other$heartbeatTimeout = other.getHeartbeatTimeout();
        if (this$heartbeatTimeout == null ? other$heartbeatTimeout != null : !((Object)this$heartbeatTimeout).equals(other$heartbeatTimeout)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        MqttAuth this$auth = this.getAuth();
        MqttAuth other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$readBufferSize = this.getReadBufferSize();
        String other$readBufferSize = other.getReadBufferSize();
        if (this$readBufferSize == null ? other$readBufferSize != null : !this$readBufferSize.equals(other$readBufferSize)) {
            return false;
        }
        String this$maxBytesInMessage = this.getMaxBytesInMessage();
        String other$maxBytesInMessage = other.getMaxBytesInMessage();
        if (this$maxBytesInMessage == null ? other$maxBytesInMessage != null : !this$maxBytesInMessage.equals(other$maxBytesInMessage)) {
            return false;
        }
        String this$nodeName = this.getNodeName();
        String other$nodeName = other.getNodeName();
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        Listener this$mqttListener = this.getMqttListener();
        Listener other$mqttListener = other.getMqttListener();
        if (this$mqttListener == null ? other$mqttListener != null : !this$mqttListener.equals(other$mqttListener)) {
            return false;
        }
        SslListener this$mqttSslListener = this.getMqttSslListener();
        SslListener other$mqttSslListener = other.getMqttSslListener();
        if (this$mqttSslListener == null ? other$mqttSslListener != null : !this$mqttSslListener.equals(other$mqttSslListener)) {
            return false;
        }
        Listener this$wsListener = this.getWsListener();
        Listener other$wsListener = other.getWsListener();
        if (this$wsListener == null ? other$wsListener != null : !this$wsListener.equals(other$wsListener)) {
            return false;
        }
        SslListener this$wssListener = this.getWssListener();
        SslListener other$wssListener = other.getWssListener();
        if (this$wssListener == null ? other$wssListener != null : !this$wssListener.equals(other$wssListener)) {
            return false;
        }
        HttpListener this$httpListener = this.getHttpListener();
        HttpListener other$httpListener = other.getHttpListener();
        return !(this$httpListener == null ? other$httpListener != null : !this$httpListener.equals(other$httpListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getKeepaliveBackoff());
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + this.getMaxClientIdLength();
        result = result * 59 + (this.isStatEnable() ? 79 : 97);
        result = result * 59 + (this.isProxyProtocolOn() ? 79 : 97);
        Long $heartbeatTimeout = this.getHeartbeatTimeout();
        result = result * 59 + ($heartbeatTimeout == null ? 43 : ((Object)$heartbeatTimeout).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        MqttAuth $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $readBufferSize = this.getReadBufferSize();
        result = result * 59 + ($readBufferSize == null ? 43 : $readBufferSize.hashCode());
        String $maxBytesInMessage = this.getMaxBytesInMessage();
        result = result * 59 + ($maxBytesInMessage == null ? 43 : $maxBytesInMessage.hashCode());
        String $nodeName = this.getNodeName();
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        Listener $mqttListener = this.getMqttListener();
        result = result * 59 + ($mqttListener == null ? 43 : $mqttListener.hashCode());
        SslListener $mqttSslListener = this.getMqttSslListener();
        result = result * 59 + ($mqttSslListener == null ? 43 : $mqttSslListener.hashCode());
        Listener $wsListener = this.getWsListener();
        result = result * 59 + ($wsListener == null ? 43 : $wsListener.hashCode());
        SslListener $wssListener = this.getWssListener();
        result = result * 59 + ($wssListener == null ? 43 : $wssListener.hashCode());
        HttpListener $httpListener = this.getHttpListener();
        result = result * 59 + ($httpListener == null ? 43 : $httpListener.hashCode());
        return result;
    }

    public String toString() {
        return "MqttServerProperties(enabled=" + this.isEnabled() + ", name=" + this.getName() + ", auth=" + this.getAuth() + ", heartbeatTimeout=" + this.getHeartbeatTimeout() + ", keepaliveBackoff=" + this.getKeepaliveBackoff() + ", readBufferSize=" + this.getReadBufferSize() + ", maxBytesInMessage=" + this.getMaxBytesInMessage() + ", debug=" + this.isDebug() + ", maxClientIdLength=" + this.getMaxClientIdLength() + ", nodeName=" + this.getNodeName() + ", statEnable=" + this.isStatEnable() + ", proxyProtocolOn=" + this.isProxyProtocolOn() + ", mqttListener=" + this.getMqttListener() + ", mqttSslListener=" + this.getMqttSslListener() + ", wsListener=" + this.getWsListener() + ", wssListener=" + this.getWssListener() + ", httpListener=" + this.getHttpListener() + ")";
    }

    public static class McpServer {
        private boolean enable = false;
        private String sseEndpoint;
        private String messageEndpoint;

        public boolean isEnable() {
            return this.enable;
        }

        public String getSseEndpoint() {
            return this.sseEndpoint;
        }

        public String getMessageEndpoint() {
            return this.messageEndpoint;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setSseEndpoint(String sseEndpoint) {
            this.sseEndpoint = sseEndpoint;
        }

        public void setMessageEndpoint(String messageEndpoint) {
            this.messageEndpoint = messageEndpoint;
        }
    }

    public static class HttpBasicAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class HttpSsl
    extends Ssl {
        private boolean enable = false;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class HttpListener
    extends Listener {
        private HttpBasicAuth basicAuth = new HttpBasicAuth();
        private McpServer mcpServer = new McpServer();
        private HttpSsl ssl = new HttpSsl();

        public HttpBasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        public McpServer getMcpServer() {
            return this.mcpServer;
        }

        public HttpSsl getSsl() {
            return this.ssl;
        }

        public void setBasicAuth(HttpBasicAuth basicAuth) {
            this.basicAuth = basicAuth;
        }

        public void setMcpServer(McpServer mcpServer) {
            this.mcpServer = mcpServer;
        }

        public void setSsl(HttpSsl ssl) {
            this.ssl = ssl;
        }
    }

    public static class Ssl {
        private String keystorePath;
        private String keystorePass;
        private String truststorePath;
        private String truststorePass;
        private ClientAuth clientAuth = ClientAuth.NONE;

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public void setKeystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public void setTruststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }
    }

    public static class SslListener
    extends Listener {
        private Ssl ssl = new Ssl();

        public Ssl getSsl() {
            return this.ssl;
        }

        public void setSsl(Ssl ssl) {
            this.ssl = ssl;
        }
    }

    public static class Listener {
        private boolean enable = false;
        private String ip;
        private Integer port;

        public Node getServerNode() {
            if (this.ip == null && this.port == null) {
                return null;
            }
            return new Node(this.ip, this.port.intValue());
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getIp() {
            return this.ip;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setPort(Integer port) {
            this.port = port;
        }
    }

    public static class MqttAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

