/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.server.solon.integration;

import java.lang.reflect.Method;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.function.ParamValueFunction;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.util.MethodParamUtil;
import org.tio.core.ChannelContext;
import org.tio.utils.mica.ExceptionUtils;

class MqttServerFunctionListener
implements IMqttFunctionMessageListener {
    private final Object bean;
    private final Method method;
    private final ParamValueFunction[] paramValueFunctions;

    MqttServerFunctionListener(Object bean, Method method, String[] topicTemplates, String[] topicFilters, MqttDeserializer deserializer) {
        this.bean = bean;
        this.method = method;
        this.paramValueFunctions = MethodParamUtil.getParamValueFunctions((Method)method, (String[])topicTemplates, (String[])topicFilters, (MqttDeserializer)deserializer);
    }

    public void onMessage(ChannelContext context, String clientId, String topic, MqttQoS qoS, MqttPublishMessage message) {
        Object[] methodParameters = this.getMethodParameters(context, topic, message, message.payload());
        try {
            this.method.invoke(this.bean, methodParameters);
        }
        catch (Throwable e) {
            throw ExceptionUtils.unchecked((Throwable)e);
        }
    }

    protected Object[] getMethodParameters(ChannelContext context, String topic, MqttPublishMessage message, byte[] payload) {
        int length = this.paramValueFunctions.length;
        Object[] parameters = new Object[length];
        for (int i = 0; i < length; ++i) {
            ParamValueFunction function = this.paramValueFunctions[i];
            parameters[i] = function.getValue(context, topic, message, payload);
        }
        return parameters;
    }
}

